#!/usr/bin/python

import os
import collections
import shutil
import logging
from ExternIndex import ExternIndex

class TrixIndex(ExternIndex):
    def __init__(self, indexIx, indexIxx, trackName, mySpecieFolderPath, **args):
        self.logger = logging.getLogger(__name__)
        self.indexIx = indexIx
        self.indexIxx = indexIxx
        self.trackName = trackName
        self.mySpecieFolderPath = mySpecieFolderPath
        self.index_settings = collections.OrderedDict()
        if "trixId" in args:
            self.trixId = args["trixId"]
        else:
            self.trixId = None

    def setExtLink(self):
        self.moveIndexFile()
        self.index_settings["searchTrix"] = "trix/%s" % self.indexIxName
        return self.index_settings

    def moveIndexFile(self):
        indexFolder = os.path.join(self.mySpecieFolderPath, 'trix')
        self.indexIxName = "".join( ( self.trackName, ".ix") )
        self.indexIxxName = "".join( ( self.trackName, ".ixx") )
        if not os.path.exists(indexFolder):
            os.makedirs(indexFolder)
        
        # Move index files to the index folder
        self.indexIxPath = os.path.join(indexFolder, self.indexIxName)
        shutil.copyfile(self.indexIx, self.indexIxPath)
        self.indexIxxPath = os.path.join(indexFolder, self.indexIxxName)
        shutil.copyfile(self.indexIxx, self.indexIxxPath)

    def setSearchIndex(self):
        if self.trixId:
            set_index = set()
            set_index.add(self.trixId)
            set_index.add("name")
            search_index = ",".join(set_index)
        else:
            search_index = "name"
        logging.debug("trixId= %s, searchIndex= %s", self.trixId, search_index)
        self.index_settings["searchIndex"] = search_index
    
        
