#!/usr/bin/perl -w
use strict;
use Getopt::Long;

my %opt=(s=>"genomic",numberofbins=>20);


GetOptions(\%opt, "f=s","version","gtf=s","range=i","annotation=s", "numberofbins=i","min_length=i","max_length=i","s=s","o=s","ignorestrand","outputall","sd=s","ssub=s","sdel=s","asd=s","assub=s","asdel=s","out=s","options","bins1=i","bins2=i","id=s");

my $cmnd;

my $prefix = "bc_$opt{id}";

if (exists $opt{version}){
	$cmnd = "python /usr/local/bin/pyBinCollector.py --version";
}
else{
	$cmnd = "python /usr/local/bin/pyBinCollector.py -f $opt{f} --gtf $opt{gtf} --annotation $opt{annotation} -o $prefix";

	if(exists $opt{outputall})
	{
	    $cmnd .= " --outputall";
	}

	if(exists $opt{options}){

	    $cmnd .= " --range=$opt{range} --numberofbins $opt{numberofbins} --min_length $opt{min_length} --max_length $opt{max_length} -s $opt{s}";

            if(exists $opt{ignorestrand}){ $cmnd .= " --ignorestrand";}
	    if(exists $opt{bins1}){ $cmnd .= " --binselect $opt{bins1} $opt{bins2}";}
	}
}


system $cmnd;
if(exists $opt{outputall}){

    system "mv sense_data_$prefix.txt $opt{sd}";
    system "mv sense_subs_$prefix.txt $opt{ssub}";
    system "mv sense_dels_$prefix.txt $opt{sdel}";
    system "mv anti_sense_data_$prefix.txt $opt{asd}";
    system "mv anti_sense_subs_$prefix.txt $opt{assub}";
    system "mv anti_sense_dels_$prefix.txt $opt{asdel}";
}
else{
    system "mv $prefix"."_cumulative_densities_$opt{annotation}"."_$opt{s}_"."$opt{numberofbins}_bins.pileup $opt{out}";
}
