#!/usr/bin/perl -w
use strict;
use Getopt::Long;

my %opt;


GetOptions(\%opt, "id=s", "input=s", "out=s", "output_path=s", "genes=s", "limit=i", "outFormat=s");

my @genes = (split /,/, $opt{genes});


# Create the output directory (for the multiple output files)
my $output_path = $opt{output_path};

my @files = ();
my $found = 0;

open(LOG, ">$opt{out}") or die "cannot write to output file\n";

foreach my $g(@genes){
	$g =~ tr/a-z/A-Z/;
	open (IN, $opt{input}) or die "Cannot open input file\n";
	while(my $line = <IN>){
		chomp ($line);
 		if ($line =~ m/##/){
			if ($found == 1){
				close OUT;
				$found = 0;
			}
			my $l = $line;
			$line =~ s/#//g;
			my $gene = (split (/\s+/,$line))[1];
			$gene =~ tr/a-z/A-Z/;

			if ($gene eq $g){
				my $sense = (split (/\s+/,$line))[2];

				my $label = "$gene.$sense";

				my $fileName = "$output_path/primary_$opt{id}_$label"."_visible_fasta";
				push (@files,$label);

				open(OUT, ">$fileName") or die "cannot write to output file\n";
				print OUT "$l\n";  
				$found = 1;
			}
		}
		elsif ($found == 1){ 
			print OUT "$line\n";    		
		}
	}
	if ($found == 1){
		close OUT;
	}
	close IN;
}


my $count = 0;
print LOG "Files produced:\n\n";
foreach(@files){

	if ($opt{outFormat}eq "align" || $opt{outFormat} eq "both"){
	    #For production version will need to provide alignment to tab on path.
	    my $label = "$_.aln";
		system "/usr/local/bin/pyAlignment2Tab.py $output_path/primary_$opt{id}_$_"."_visible_fasta --limit $opt{limit} --galaxy > $output_path/primary_$opt{id}_$label"."_visible_tabular";
		print LOG "$_.aln\n";
		$count ++;
		if ($opt{outFormat}eq "align"){
			system "rm $output_path/primary_$opt{id}_$_"."_visible_fasta";
		}
	}
	if ($opt{outFormat}eq "fasta" || $opt{outFormat} eq "both"){
		print LOG "$_\n";
		$count ++;
	}
}
print LOG "\n$count files produced:\n\n";
print LOG "Please refresh history if not all files are displayed";

close LOG;


