assp_to_est <- function(assp, outfile) {
    
    # convert to a dataframe
    result <- data.frame(assp[1])
    for(idx in seq(2,length(attr(assp,'names')))) {
        result <- cbind(result, assp[idx])
    }
    # add a column of timestamps
    start <- attr(assp, 'startTime')
    rate <- attr(assp, 'sampleRate')
    sampletime <- seq(start, by=1/rate, length.out=nrow(result))
    # and a column of 1s for some reason
    #one <- rep(1, nrow(result))
    result <- cbind(sampletime, result)
    
    # write header
    #write("EST_File Track", file=outfile)
    #write("DataType ascii", file=outfile, append=T)
    #write("BreaksPresent true", file=outfile, append=T)    
    #write(paste("NumFrames", nrow(result)), file=outfile, append=T)    
    
    #count <- 0 # count overall number of columns
    #vcount <- 1 # count variables in assp obj
    #for(name in attr(assp,'names')) {
    #    for (coln in seq(ncol(data.frame(assp[vcount])))) {
    #        colname = paste(name, coln, sep="_")
    #        write(c(paste("Channel_", count, " ", colname, sep="")), file=outfile, append=T)
    #        count <- count+1
    #    }
    #    vcount <- vcount+1
    #}
    #write(paste("NumChannels", count), file=outfile, append=T)
    #write("EST_Header_End", file=outfile, append=T)

    
    write.table(result, file=outfile, sep="\t", quote=F, row.names=F, col.names=T, append=F)
}