#!/usr/bin/env python

import datetime
import json
import os
import re
from urllib.request import urlretrieve
import sys
import tarfile


def main():
	# Read in given out_file and create target directory for file download
    with open(sys.argv[1]) as fh:
        params = json.load(fh)
    target_directory = params['output_data'][0]['extra_files_path']
    os.mkdir(target_directory)

	# Process parameters for metadata and file download
    url = params['param_dict']['url'].rstrip("/") + "/" + params['param_dict']['file_name'].lstrip("/")
    m = re.search(r"_([^_]*?)_vep_(\d+?)_", params['param_dict']['file_name'])
    version = str(m.group(2))
    cache_type = m.group(1) if m.group(1) == "merged" or m.group(1) == "refseq" else "default"

	# Download and extract given cache archive, remove archive afterwards
    final_file, headers = urlretrieve(url, os.path.join(target_directory, params['param_dict']['file_name']))
    tar = tarfile.open(final_file, "r:gz")
    tar.extractall(target_directory)
    tar.close()
    os.remove(final_file)

    # Construct metadata for the new data table entry
    data_manager_dict = {
        'data_tables': {
            'vep_cache_databases': [
                {
                    'value': params['param_dict']['file_name'].strip(".tar.gz"),
                    'dbkey': params['param_dict']['dbkey'],
                    'version': version,
                    'cachetype': cache_type,
                    'name': params['param_dict']['display_name'],
                    'path': './%s' % params['param_dict']['file_name'].strip(".tar.gz")
                }
            ]
        }
    }

    # Save metadata to out_file
    with open(sys.argv[1], 'w') as fh:
        json.dump(data_manager_dict, fh, sort_keys=True)


if __name__ == "__main__":
    main()
