#!/bin/sh
# SET TOOL DIRECTORY

CMDNAME=`basename $0`

while getopts a:b:o:gr OPT
do
  case $OPT in
    "a" ) FLG_A="TRUE" ; VALUE_A="$OPTARG" ;;
    "b" ) FLG_B="TRUE" ; VALUE_B="$OPTARG" ;;
    "o" ) FLG_O="TRUE" ; VALUE_O="$OPTARG" ;;
    "g" ) FLG_G="TRUE" ;;
    "r" ) FLG_R="TRUE" ;;
      * ) echo "Usage: $CMDNAME [-a VALUE] [-b] [-o VALUE] [-gr]" 1>&2
          exit 1 ;;
  esac
done

# SINGLE END OR PAIR END
if [ ! $FLG_B ] ; then
  ARGS="--read1=$VALUE_A"
else
  ARGS="--read1=$VALUE_A --read2=$VALUE_B"
fi

# GZIPPED OR NOT
if [ $FLG_G ] ; then
  CMD1="./illumina_export2sam_gz.pl $ARGS"
else
  CMD1="./illumina_export2sam.pl $ARGS"
fi

# MODIFY ACCORDING TO THE REFERENCE
if [ $FLG_R ] ; then
  CMD2='$tmp=$_;$tmp=~s/chr_fragments\.fa\///g;$tmp=~s/(chr\w+)\.fa/$1/g;print $tmp;'
  CMD="$CMD1 | perl -ne '$CMD2'"
else
  CMD=$CMD1
fi

echo $CMD
eval $CMD > $VALUE_O
