/*
 * Decompiled with CFR 0.152.
 */
package idenIPETsGalaxy;

import idenIPETsGalaxy.Chrom;
import idenIPETsGalaxy.ConstValue;
import idenIPETsGalaxy.Pet;
import idenIPETsGalaxy.Read;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PetSet
implements ConstValue {
    private List<Pet> pet = new ArrayList<Pet>();

    public List<Pet> getPet() {
        return this.pet;
    }

    public Pet getPet(int i) {
        return this.pet.get(i);
    }

    public void disp() {
        int i = 0;
        while (i < this.pet.size()) {
            this.pet.get(i).disp();
            ++i;
        }
    }

    public void sortPETs() {
        Comparator<Pet> startComparator2 = new Comparator<Pet>(){

            @Override
            public int compare(Pet pet1, Pet pet2) {
                return pet1.getRead2().getStart() - pet2.getRead2().getStart();
            }
        };
        Collections.sort(this.pet, startComparator2);
        Comparator<Pet> chromComparator2 = new Comparator<Pet>(){

            @Override
            public int compare(Pet pet1, Pet pet2) {
                return Chrom.fromHChrom(pet1.getRead2().getChrom()) - Chrom.fromHChrom(pet2.getRead2().getChrom());
            }
        };
        Collections.sort(this.pet, chromComparator2);
        Comparator<Pet> startComparator1 = new Comparator<Pet>(){

            @Override
            public int compare(Pet pet1, Pet pet2) {
                return pet1.getRead1().getStart() - pet2.getRead1().getStart();
            }
        };
        Collections.sort(this.pet, startComparator1);
        Comparator<Pet> chromComparator1 = new Comparator<Pet>(){

            @Override
            public int compare(Pet pet1, Pet pet2) {
                return Chrom.fromHChrom(pet1.getRead1().getChrom()) - Chrom.fromHChrom(pet2.getRead1().getChrom());
            }
        };
        Collections.sort(this.pet, chromComparator1);
    }

    public void removeSisterPETs() {
        ArrayList<Pet> pet = new ArrayList<Pet>();
        pet.add(new Pet(this.pet.get(0)));
        int i = 1;
        while (i < this.pet.size()) {
            if (!this.pet.get(i).sameAs(this.pet.get(i - 1))) {
                pet.add(new Pet(this.pet.get(i)));
            }
            ++i;
        }
        this.pet = pet;
    }

    public void removeSelfPETs(int width) {
        ArrayList<Pet> pet = new ArrayList<Pet>();
        int i = 0;
        while (i < this.pet.size()) {
            int d = Math.abs(this.pet.get(i).getRead1().getStart() - this.pet.get(i).getRead2().getStart());
            if (width < d) {
                pet.add(new Pet(this.pet.get(i)));
            }
            ++i;
        }
        this.pet = pet;
    }

    public void calcMapAbility(int mapClass, String path) {
        int[] hits = new int[5];
        int total = 0;
        try {
            String buff;
            BufferedReader br = new BufferedReader(new FileReader(path));
            while ((buff = br.readLine()) != null) {
                int tClass;
                String[] splits = buff.split("\\t");
                Read read1 = new Read(splits[0], splits[2], Integer.parseInt(splits[3]), Integer.parseInt(splits[3]) + 36);
                Read read2 = new Read(splits[0], splits[12], Integer.parseInt(splits[13]), Integer.parseInt(splits[13]) + 36);
                if (!read1.checkHit() && !read2.checkHit()) {
                    hits[4] = hits[4] + 1;
                    tClass = 4;
                } else if (!read2.checkHit()) {
                    hits[2] = hits[2] + 1;
                    tClass = 2;
                } else if (!read1.checkHit()) {
                    hits[3] = hits[3] + 1;
                    tClass = 3;
                } else if (read1.getChrom().equals(read2.getChrom())) {
                    hits[0] = hits[0] + 1;
                    tClass = 0;
                } else {
                    hits[1] = hits[1] + 1;
                    tClass = 1;
                }
                if (mapClass != tClass) continue;
                this.pet.add(new Pet(read1, read2));
            }
            total = hits[0] + hits[1] + hits[2] + hits[3] + hits[4];
            System.out.println("  Double intra-chromosome hits: " + (double)hits[0] / (double)total + " (" + hits[0] + ")");
            System.out.println("  Double inter-chromosome hits: " + (double)hits[1] / (double)total + " (" + hits[1] + ")");
            System.out.println("  Single hits (read1): " + (double)hits[2] / (double)total + " (" + hits[2] + ")");
            System.out.println("  Single hits (read2): " + (double)hits[3] / (double)total + " (" + hits[3] + ")");
            System.out.println("  Others: " + (double)hits[4] / (double)total + " (" + hits[4] + ")");
            br.close();
        }
        catch (FileNotFoundException L04) {
            System.out.println("File not found");
        }
        catch (IOException L05) {
            System.out.println("File not found");
        }
    }

    public void printDistribution(String path) {
        int[] dist = new int[29];
        int i = 0;
        while (i < this.pet.size()) {
            int d = Math.abs(this.pet.get(i).getRead1().getStart() - this.pet.get(i).getRead2().getStart());
            int j = 1;
            while (j <= 28) {
                if (d < (int)Math.pow(2.0, j)) {
                    int n = j - 1;
                    dist[n] = dist[n] + 1;
                    break;
                }
                if (j == 28) {
                    int n = j;
                    dist[n] = dist[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(path)));
            i = 0;
            while (i <= 28) {
                pw.println(String.valueOf((int)Math.pow(2.0, i)) + "\t" + dist[i]);
                ++i;
            }
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void idenIPETs(String path, int width, int minN) {
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(path)));
            int i = 0;
            while (i < this.pet.size()) {
                int n = 0;
                int j = i;
                while (j < this.pet.size()) {
                    if (!this.pet.get(i).getRead1().getChrom().equals(this.pet.get(j).getRead1().getChrom()) || this.pet.get(i).getRead1().getStart() + width <= this.pet.get(j).getRead1().getStart()) break;
                    if (this.pet.get(i).compareTo2(this.pet.get(j), width * 2)) {
                        ++n;
                    }
                    ++j;
                }
                if (n >= minN) {
                    pw.println("Number of interaction PETs: " + n);
                    j = i;
                    while (j < this.pet.size()) {
                        if (!this.pet.get(i).getRead1().getChrom().equals(this.pet.get(j).getRead1().getChrom()) || this.pet.get(i).getRead1().getStart() + width <= this.pet.get(j).getRead1().getStart()) break;
                        if (this.pet.get(i).compareTo2(this.pet.get(j), width * 2)) {
                            pw.print(String.valueOf(this.pet.get(j).getRead1().getChrom()) + "\t" + this.pet.get(j).getRead1().getStart() + "\t" + this.pet.get(j).getRead1().getEnd() + "\t");
                            pw.println(String.valueOf(this.pet.get(j).getRead2().getChrom()) + "\t" + this.pet.get(j).getRead2().getStart() + "\t" + this.pet.get(j).getRead2().getEnd());
                        }
                        ++j;
                    }
                    pw.println();
                    i = j - 1;
                }
                ++i;
            }
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeReversedPETs() {
        ArrayList<Pet> pet = new ArrayList<Pet>();
        int i = 0;
        int max = 0;
        while (i < this.pet.size()) {
            if (max < Integer.parseInt(this.pet.get(i).getRead1().getName())) {
                max = Integer.parseInt(this.pet.get(i).getRead1().getName());
            }
            ++i;
        }
        int[] id = new int[max + 1];
        i = 0;
        while (i < this.pet.size()) {
            if (id[Integer.parseInt(this.pet.get(i).getRead1().getName())] == 0) {
                id[Integer.parseInt((String)this.pet.get((int)i).getRead1().getName())] = 1;
                pet.add(new Pet(this.pet.get(i)));
            }
            ++i;
        }
        this.pet = pet;
    }

    public void addReversedPETs() {
        int size = this.pet.size();
        int i = 0;
        while (i < size) {
            this.pet.add(new Pet(this.pet.get(i).getRead2(), this.pet.get(i).getRead1()));
            ++i;
        }
    }
}

