/*
 * Decompiled with CFR 0.152.
 */
package idenIPETsGalaxy;

import idenIPETsGalaxy.Read;

public class Pet {
    private Read read1;
    private Read read2;

    public Read getRead1() {
        return this.read1;
    }

    public Read getRead2() {
        return this.read2;
    }

    public void setRead1(Read read1) {
        this.read1 = new Read(read1);
    }

    public void setRead2(Read read2) {
        this.read2 = new Read(read2);
    }

    public Pet(Read read1, Read read2) {
        this.read1 = new Read(read1);
        this.read2 = new Read(read2);
    }

    public Pet(Pet original) {
        this.read1 = new Read(original.read1);
        this.read2 = new Read(original.read2);
    }

    public void adjustWidth(int width) {
        int center = (this.getRead1().getStart() + this.getRead1().getEnd()) / 2;
        this.getRead1().setStart(center - width / 2);
        this.getRead1().setEnd(center + width / 2);
        center = (this.getRead2().getStart() + this.getRead2().getEnd()) / 2;
        this.getRead2().setStart(center - width / 2);
        this.getRead2().setEnd(center + width / 2);
    }

    public boolean compareTo1(Pet pet, int width) {
        if (this.read1.getChrom().equals(pet.read1.getChrom())) {
            if (this.read1.getStart() - width / 2 <= pet.read1.getStart() && pet.read1.getStart() <= this.read1.getEnd() + width / 2) {
                return true;
            }
            if (this.read1.getStart() - width / 2 <= pet.read1.getEnd() && pet.read1.getEnd() <= this.read1.getEnd() + width / 2) {
                return true;
            }
            if (pet.read1.getStart() - width / 2 <= this.read1.getStart() && this.read1.getStart() <= pet.read1.getEnd() + width / 2) {
                return true;
            }
            return pet.read1.getStart() - width / 2 <= this.read1.getEnd() && this.read1.getEnd() <= pet.read1.getEnd() + width / 2;
        }
        return false;
    }

    public boolean compareTo2(Pet pet, int width) {
        if (this.read2.getChrom().equals(pet.read2.getChrom())) {
            if (this.read2.getStart() - width / 2 <= pet.read2.getStart() && pet.read2.getStart() <= this.read2.getEnd() + width / 2) {
                return true;
            }
            if (this.read2.getStart() - width / 2 <= pet.read2.getEnd() && pet.read2.getEnd() <= this.read2.getEnd() + width / 2) {
                return true;
            }
            if (pet.read2.getStart() - width / 2 <= this.read2.getStart() && this.read2.getStart() <= pet.read2.getEnd() + width / 2) {
                return true;
            }
            return pet.read2.getStart() - width / 2 <= this.read2.getEnd() && this.read2.getEnd() <= pet.read2.getEnd() + width / 2;
        }
        return false;
    }

    public boolean sameAs(Pet pet) {
        if (this.getRead1().getName().equals(pet.getRead1().getName())) {
            return true;
        }
        if (this.read1.sameAs(pet.getRead1()) && this.read2.sameAs(pet.getRead2())) {
            return true;
        }
        return this.read1.sameAs(pet.getRead2()) && this.read2.sameAs(pet.getRead1());
    }

    public void disp() {
        System.out.print(String.valueOf(this.getRead1().getChrom()) + "\t" + this.getRead1().getStart() + "\t" + this.getRead1().getEnd() + "\t");
        System.out.println(String.valueOf(this.getRead2().getChrom()) + "\t" + this.getRead2().getStart() + "\t" + this.getRead2().getEnd());
    }
}

