#!/usr/bin/env python

import sys
from Population import Population

input_file, output_file = sys.argv[1:3]
tags = sys.argv[3:]

aliases = {}

for tag in tags:
    column, alias = tag.split(':', 1)
    column = column.strip()
    alias = alias.strip()
    if alias:
        aliases[column] = alias

p_total = Population()
p_total.from_population_file(input_file)

with open(output_file, 'w') as ofh:
    for column in p_total.column_list():
        individual = p_total.individual_with_column(column)
        real_name = individual.real_name
        rv = [column, real_name, '']
        if column in aliases:
            alias = aliases[column]
            if alias != real_name:
                rv[2] = alias
        print >> ofh, '\t'.join(rv)

sys.exit(0)

