import sys, csv, argparse, os

from bl.vl.kb import KnowledgeBase as KB
import bl.vl.utils.ome_utils as vlu
from bl.vl.utils import get_logger, LOG_LEVELS


def make_parser():
    parser = argparse.ArgumentParser(description='set parents of the selected individuals to None')
    parser.add_argument('--logfile', type=str, help='log file (default=stderr)')
    parser.add_argument('--loglevel', type=str, choices=LOG_LEVELS,
                        help='logging level (default=INFO)', default='INFO')
    parser.add_argument('-H', '--host', type=str, help='omero hostname')
    parser.add_argument('-U', '--user', type=str, help='omero user')
    parser.add_argument('-P', '--passwd', type=str, help='omero password')
    parser.add_argument('--in_file', type=str, required=True,
                        help='list of the individuals')
    parser.add_argument('--out_file', type=str, required=True,
                        help='output file')
    return parser


def main(argv):
    parser = make_parser()
    args = parser.parse_args(argv)

    logger = get_logger('drop_parental_info', level=args.loglevel,
                        filename=args.logfile)

    try:
        host = args.host or vlu.ome_host()
        user = args.user or vlu.ome_user()
        passwd = args.passwd or vlu.ome_passwd()
    except ValueError, ve:
        logger.critical(ve)
        sys.exit(ve)

    kb = KB(driver='omero')(host, user, passwd)

    logger.info('Retrieving individuals')
    inds = kb.get_objects(kb.Individual)
    logger.info('Retrieved %d individuals' % len(inds))
    inds_lookup = {}
    for i in inds:
        inds_lookup[i.id] = i

    with open(args.in_file) as in_file:
        reader = csv.DictReader(in_file, delimiter='\t')
        records = []
        for row in reader:
            try:
                # The 'individual' : inds_lookup[row['individual']].id
                # is quite redundant but is a usefull check in order
                # to filter wrong VIDs
                record = {'individual' : inds_lookup[row['individual']].id,
                          'father' : 'None',
                          'mother' : 'None'}
                records.append(record)
            except KeyError, ke:
                logger.warning('Individual with VID %s does not exist, skipping line' % ke)

    with open(args.out_file, 'w') as out_file:
        writer = csv.DictWriter(out_file, ['individual', 'father', 'mother'],
                                delimiter = '\t')
        writer.writeheader()
        writer.writerows(records)

if __name__ == '__main__':
    main(sys.argv[1:])
