#!/bin/sh                                                                       

CMD=""
PYTH_PATH="PYTHONPATH=/SHARE/USERFS/els7/users/galaxy/develop/usr-cluster/lib/p\
ython2.7/site-packages/:/SHARE/USERFS/els7/users/biobank/lib/"
runner="$(dirname ${BASH_SOURCE[0]})/"
until [ -z $1 ]
    do

    opt_host='--host='
    opt_user='--user='
    opt_passwd='--passwd='
    opt_interpreter='--interpreter='
    opt_runner='--runner='
    if [[ $1 == $opt_host* ]]; then
        host=`echo $1 | cut -d '=' -f2 | cut -d '.' -f1`
        if [ -z $host -o $host == 'None' ]; then
            echo 'ERROR. Missing omero host parameter. Please, set Omero Host in your user preferences' > /dev/null >&2
            exit -1
        fi
        PYTH_PATH+=$host
        HOST=`echo $1 | cut -d '=' -f2`
        CMD+=' '$1
    elif [[ $1 == $opt_user* ]]; then
        user=`echo $1 | cut -d '=' -f2`
        if [ -z $user -o $user == 'None' ]; then
            echo 'ERROR. Missing omero user parameter. Please, set Omero User in your user preferences' > /dev/null >&2
            exit -1
        fi
        CMD+=' '$1
    elif [[ $1 == $opt_passwd* ]]; then
        passwd=`echo $1 | cut -d '=' -f2`
        if [ -z $passwd -o $passwd == 'None' ]; then
            echo 'ERROR. Missing omero password parameter. Please, set Omero Password in your user preferences' > /dev/null >&2
            exit -1
        fi
        CMD+=' '$1
    elif [[ $1 == $opt_runner* ]]; then
        runner+=`echo $1 | cut -d '=' -f2`
    elif [[ $1 == $opt_interpreter* ]]; then
        interpreter=`echo $1 | cut -d '=' -f2`
    else
        CMD+=' '$1
    fi
    shift
done
export $PYTH_PATH/:$PYTHONPATH
profile="/SHARE/USERFS/els7/users/biobank/lib/${HOST}.biobank.profile"
if [ -f $profile ]; then
    source $profile
    CMD=$interpreter' '$runner$CMD
    $CMD
else
    echo "ERROR. Biobank profile file doesn't exist. Please, check Omero Host in your user preferences" > /dev/null >&2
    exit -1
fi
