'''
'''

import argparse, csv, sys

from bl.vl.kb import KnowledgeBase as KB
import bl.vl.utils.ome_utils as vlu
from bl.vl.utils import get_logger, LOG_LEVELS


def make_parser():
    parser = argparse.ArgumentParser(description='retrieve studies details')
    parser.add_argument('--logfile', type=str, help='log file (default=stderr)')
    parser.add_argument('--loglevel', type=str, choices=LOG_LEVELS,
                        help='logging level (default=INFO)', default='INFO')
    parser.add_argument('-H', '--host', type=str, help='omero hostname')
    parser.add_argument('-U', '--user', type=str, help='omero user')
    parser.add_argument('-P', '--passwd', type=str, help='omero passwd')
    parser.add_argument('--out_file', type=str, required=True,
                        help='output file with studies details')
    return parser


def main(argv):
    parser = make_parser()
    args = parser.parse_args(argv)

    logger = get_logger('get_studies', level=args.loglevel,
                        filename=args.logfile)

    try:
        host = args.host or vlu.ome_host()
        user = args.user or vlu.ome_user()
        passwd = args.passwd or vlu.ome_passwd()
    except ValueError, ve:
        logger.critical(ve)
        sys.exit(ve)

    kb = KB(driver='omero')(host, user, passwd)

    logger.info('Retrieving studies')
    studies = kb.get_objects(kb.Study)
    logger.info('Retrieved {} studies'.format(len(studies)))
    records = []
    for s in studies:
        enr = kb.get_enrolled(s)
        rec = {'label': s.label,
               'description': s.description,
               'enrolled': len(enr)}
        records.append(rec)
          
    with open(args.out_file, 'w') as outfile:
        writer = csv.DictWriter(outfile, ['label', 'description', 'enrolled'],
                                delimiter='\t')
        # writer.writeheader()
        writer.writerows(sorted(records, key=lambda key: key['label']))

if __name__ == '__main__':
    main(sys.argv[1:])
