import os
import errno

from argparse import ArgumentParser
from datetime import datetime
from json import dumps, loads
from urllib.parse import urlparse
from shutil import copy


def main(args):
    with open(args.data_manager_json, 'r') as json_in:
        data_manager_input = loads(json_in.read())
    target_directory = data_manager_input['output_data'][0]['extra_files_path']

    try:
        os.mkdir(target_directory)
    except OSError as exc:
        if exc.errno == errno.EEXIST and os.path.isdir(target_directory):
            pass
        else:
            raise

    date = str(datetime.now())
    base = urlparse(args.database_url).hostname.split('.')[-2]
    name = f'{base}_{date}'.replace(' ', '_')

    if base not in ['hmdb', 't3db']:
        raise NameError('Unknown database')
    
    src = os.path.join(args.tool_data_dir, f'{base}.h5')
    dst = os.path.join(target_directory, f'{name}.h5')
    copy(src, dst)
        
    data_table_entry = {
        'data_tables': {
            'recetox_metabolite_databases' : [
                {
                    "value": name,
                    "name": name,
                    "date": date,
                    "path": f'{name}.h5',
                }
            ]
        }
    }

    with open(args.data_manager_json, 'w') as json_out:
        json_out.write(dumps(data_table_entry))


if __name__ == "__main__":
    parser = ArgumentParser()
    parser.add_argument('--tool_data_dir')
    parser.add_argument('--database_url')
    parser.add_argument('--data_manager_json')
    main(parser.parse_args())