#####################
# CLASS DECLARATION #
#####################

LipidmapsConn <- methods::setRefClass("LipidmapsConn", contains = "RemotedbConn")

###############
# CONSTRUCTOR #
###############

LipidmapsConn$methods( initialize = function(...) {
	# From http://www.lipidmaps.org/data/structure/programmaticaccess.html:
	# If you write a script to automate calls to LMSD, please be kind and do not hit our server more often than once per 20 seconds. We may have to kill scripts that hit our server more frequently.
	callSuper(scheduler = UrlRequestScheduler$new(t = 20), ...)
})

##########################
# GET ENTRY CONTENT TYPE #
##########################

LipidmapsConn$methods( getEntryContentType = function() {
	return(BIODB.CSV)
})

#####################
# GET ENTRY CONTENT #
#####################

LipidmapsConn$methods( getEntryContent = function(id) {

	# Initialize return values
	content <- rep(NA_character_, length(id))

	# Request
	content <- vapply(id, function(x) .self$.get.url(get.entry.url(BIODB.LIPIDMAPS, x, content.type = BIODB.CSV)), FUN.VALUE = '')

	return(content)
})

################
# CREATE ENTRY #
################

LipidmapsConn$methods( createEntry = function(content, drop = TRUE) {
	return(createLipidmapsEntryFromCsv(content, drop = drop))
})
