#!/bin/sh

##
## Galaxy wrapper for SED command
##

##
## command line arguments:
##   input_file
##   output_file
##   sed-program
##   [other parameters passed on to sed]

INPUT="$1"
OUTPUT="$2"
PROG="$3"

shift 3

if [ -z "$PROG" ]; then
	echo usage: $0 INPUTFILE OUTPUTFILE SED-PROGRAM [other sed patameters] >&2
	exit 1
fi

if [ ! -r "$INPUT" ]; then
	echo "error: input file ($INPUT) not found!" >&2
	exit 1
fi

# Messages printed to STDOUT will be displayed in the "INFO" field in the galaxy dataset.
# This way the user can tell what was the command
echo "sed" "$@" "$PROG"

#$GALAXY_TOOLS/sed/sed/sed -r --sandbox "$@" "$PROG" "$INPUT" > "$OUTPUT"
sed -r "$@" "$PROG" "$INPUT" > "$OUTPUT"
if (( $? ));  then exit; fi

exit 0
