/*
 * Decompiled with CFR 0.152.
 */
package cytoexport.tool;

import com.pri.cytoexport.tool.CytoExportTool;
import com.pri.general.Utils;
import java.io.FileInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class CytoExportToolTest
extends TestCase {
    public void test_basic() throws Exception {
        String csvDataFile = "test/cytoscape_integration/cytoexportTool/Galaxy77-small.csv";
        String vizzMapPropsFile = "test/cytoscape_integration/cytoexportTool/session_vizmap.props";
        String alternativeTableImportJsonFile = "test/cytoscape_integration/cytoexportTool/network_layout.json";
        String cysOutFileName = "test/cytoscape_integration/cytoexportTool/result/basic.cys";
        String networkPicturesPath = "test/cytoscape_integration/cytoexportTool/result/";
        String htmlReportFile = String.valueOf(cysOutFileName) + ".html";
        String logFile = String.valueOf(cysOutFileName) + "_log.txt";
        CytoExportTool cytoTool = new CytoExportTool();
        cytoTool.makeCysFile("junit_test network", csvDataFile, vizzMapPropsFile, "default2", alternativeTableImportJsonFile, cysOutFileName, htmlReportFile, networkPicturesPath, logFile);
    }

    public void test_templates() throws Exception {
        String csvDataFile = "test/data/Quantifere_Inference_log.csv";
        String vizMapPropsFile = "/com/pri/cytoexport/resources/quantifere_network_layout.props";
        String alternativeTableImportJsonFile = "/com/pri/cytoexport/resources/quantifere_network_config_no_layout.json";
        vizMapPropsFile = Utils.getTempFileFromResource((String)vizMapPropsFile, (boolean)false);
        alternativeTableImportJsonFile = Utils.getTempFileFromResource((String)alternativeTableImportJsonFile, (boolean)false);
        String modifiedJsonFile = CytoExportTool.editJsonFileForDynamicAttributesAndRemoveUnnecessaryAttributes(csvDataFile, alternativeTableImportJsonFile);
        String cysOutFileName = "test/data/cytoexportTool/result/basic.cys";
        String networkPicturesPath = "test/data/cytoexportTool/result/";
        String htmlReportFile = String.valueOf(cysOutFileName) + ".html";
        String logFile = String.valueOf(cysOutFileName) + "_log.txt";
        CytoExportTool cytoTool = new CytoExportTool();
        cytoTool.makeCysFile("junit_test network", csvDataFile, vizMapPropsFile, "default2", modifiedJsonFile, cysOutFileName, htmlReportFile, networkPicturesPath, logFile);
    }

    public void test_editJsonFileStep() throws Exception {
        String csvDataFile = "test/cytoscape_integration/outputCSV.csvout_inference_log.csv";
        String alternativeTableImportJsonFile = "/com/pri/cytoexport/resources/quantifere_network_config.json";
        alternativeTableImportJsonFile = Utils.getTempFileFromResource((String)alternativeTableImportJsonFile, (boolean)false);
        String modifiedJsonFile = CytoExportTool.editJsonFileForDynamicAttributesAndRemoveUnnecessaryAttributes(csvDataFile, alternativeTableImportJsonFile);
        JSONParser parser = new JSONParser();
        String jsonString = Utils.file2String((InputStream)new FileInputStream(alternativeTableImportJsonFile));
        JSONObject jsonObject = (JSONObject)parser.parse(jsonString);
        int originalTargetAttributesLength = ((JSONArray)jsonObject.get((Object)"targetAttributes")).size();
        parser = new JSONParser();
        jsonString = Utils.file2String((InputStream)new FileInputStream(modifiedJsonFile));
        jsonObject = (JSONObject)parser.parse(jsonString);
        Object dynamicTargetAttributes = jsonObject.get((Object)"dynamicTargetAttributes");
        CytoExportToolTest.assertTrue((dynamicTargetAttributes == null ? 1 : 0) != 0);
        Object dynamicAttributesInterpretation = jsonObject.get((Object)"dynamicAttributesInterpretation");
        CytoExportToolTest.assertTrue((dynamicAttributesInterpretation == null ? 1 : 0) != 0);
        String[] expectedColumns = new String[]{"std_z_RibO_1_msE1", "std_z_RibO_1_msE2", "std_z_RibO_2_msE1", "std_z_RibO_2_msE4", "std_z_RibO_3_msE1", "std_z_RibO_3_msE2", "std_z_RibO_4_msE1", "std_z_RibO_4_msE2", "std_z_RibO_5_msE1", "std_z_RibO_5_msE2", "std_z_RibO_6_msE1", "std_z_RibO_6_msE2", "std_z_RibS_1_msE1", "std_z_RibS_1_msE3", "std_z_RibS_2_msE1", "std_z_RibS_2_msE4", "std_z_RibS_3_msE1", "std_z_RibS_3_msE2", "std_z_RibS_4_msE1", "std_z_RibS_4_msE2", "std_z_RibS_5_msE1", "std_z_RibS_5_msE3", "std_z_RibS_6_msE1", "std_z_RibS_6_msE2", "raw_RibO_1_msE1", "raw_RibO_1_msE2", "raw_RibO_2_msE1", "raw_RibO_2_msE4", "raw_RibO_3_msE1", "raw_RibO_3_msE2", "raw_RibO_4_msE1", "raw_RibO_4_msE2", "raw_RibO_5_msE1", "raw_RibO_5_msE2", "raw_RibO_6_msE1", "raw_RibO_6_msE2", "raw_RibS_1_msE1", "raw_RibS_1_msE3", "raw_RibS_2_msE1", "raw_RibS_2_msE4", "raw_RibS_3_msE1", "raw_RibS_3_msE2", "raw_RibS_4_msE1", "raw_RibS_4_msE2", "raw_RibS_5_msE1", "raw_RibS_5_msE3", "raw_RibS_6_msE1", "raw_RibS_6_msE2", "scaled_raw_RibO_1_msE1", "scaled_raw_RibO_1_msE2", "scaled_raw_RibO_2_msE1", "scaled_raw_RibO_2_msE4", "scaled_raw_RibO_3_msE1", "scaled_raw_RibO_3_msE2", "scaled_raw_RibO_4_msE1", "scaled_raw_RibO_4_msE2", "scaled_raw_RibO_5_msE1", "scaled_raw_RibO_5_msE2", "scaled_raw_RibO_6_msE1", "scaled_raw_RibO_6_msE2", "scaled_raw_RibS_1_msE1", "scaled_raw_RibS_1_msE3", "scaled_raw_RibS_2_msE1", "scaled_raw_RibS_2_msE4", "scaled_raw_RibS_3_msE1", "scaled_raw_RibS_3_msE2", "scaled_raw_RibS_4_msE1", "scaled_raw_RibS_4_msE2", "scaled_raw_RibS_5_msE1", "scaled_raw_RibS_5_msE3", "scaled_raw_RibS_6_msE1", "scaled_raw_RibS_6_msE2"};
        JSONArray targetAttributes = (JSONArray)jsonObject.get((Object)"targetAttributes");
        String[] stringArray = expectedColumns;
        int n = expectedColumns.length;
        int n2 = 0;
        while (n2 < n) {
            String expectedColumn = stringArray[n2];
            CytoExportToolTest.assertEquals((String)expectedColumn, (String)this.columnInAttributeList(expectedColumn, targetAttributes));
            ++n2;
        }
        CytoExportToolTest.assertEquals((int)(originalTargetAttributesLength + expectedColumns.length), (int)targetAttributes.size());
    }

    private String columnInAttributeList(String expectedColumn, JSONArray targetAttributes) {
        for (Object targetAttribute : targetAttributes) {
            if (!((String)targetAttribute).equals(expectedColumn)) continue;
            return (String)targetAttribute;
        }
        return "";
    }
}

