/*
 * Decompiled with CFR 0.152.
 */
package com.pri.cytoexport.tool;

import com.pri.cytoexport.cytoscape.temp.CustomBitmapExporter;
import com.pri.cytoexport.cytoscape.temp.CustomSVGExporter;
import com.pri.cytoexport.tool.CytoExportReport;
import com.pri.general.CsvReader;
import com.pri.general.Utils;
import com.pri.general.ZipWriter;
import csplugins.layout.LayoutPlugin;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.writers.XGMMLWriter;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.plugin.PluginException;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import nl.nbic.brs.alttableimport.NetworkCreator;
import nl.nbic.brs.alttableimport.persistence.SaveableSettings;
import nl.nbic.brs.alttableimport.persistence.SettingsPersistence;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class CytoExportTool {
    public static final String CONFIG_INPUT_CUSTOM = "customConfig";
    public static final String CONFIG_INPUT_TEMPLATE = "existingTemplate";

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage: java -jar CytoExport.jar -csvDataFile $csvDataFile -configInputMode $configInputMode -vizMapPropsFile $vizMapPropsFile -alternativeTableImportJsonFile $alternativeTableImportJsonFile -cysOutFile $cysOutFile [-htmlReportFile $htmlReportFile -picturesPath $htmlReportFile.files_path]");
            throw new RuntimeException("wrong arguments");
        }
        Date startDate = new Date();
        String csvDataFile = Utils.getCmdParameter((String[])args, (String)"csvDataFile", (boolean)true);
        String configInputMode = Utils.getCmdParameter((String[])args, (String)"configInputMode", (boolean)true);
        String vizMapPropsFile = Utils.getCmdParameter((String[])args, (String)"vizMapPropsFile", (boolean)true);
        String vizStyleName = Utils.getCmdParameter((String[])args, (String)"vizStyleName", (boolean)true);
        String alternativeTableImportJsonFile = Utils.getCmdParameter((String[])args, (String)"alternativeTableImportJsonFile", (boolean)true);
        String cysOutFile = Utils.getCmdParameter((String[])args, (String)"cysOutFile", (boolean)true);
        String htmlReportFile = Utils.getCmdParameter((String[])args, (String)"htmlReportFile", (boolean)false);
        String picturesPath = Utils.getCmdParameter((String[])args, (String)"picturesPath", (boolean)false);
        String logFile = Utils.getCmdParameter((String[])args, (String)"logFile", (boolean)true);
        String networkName = Utils.getCmdParameter((String[])args, (String)"networkName", (boolean)false);
        int nrNetworks = CytoExportTool.runCtyExportTool(networkName, csvDataFile, configInputMode, vizMapPropsFile, vizStyleName, alternativeTableImportJsonFile, cysOutFile, htmlReportFile, picturesPath, logFile);
        Date endDate = new Date();
        System.out.println("Nr. of networks generated =[" + nrNetworks + "]");
        System.out.println("Took " + (endDate.getTime() - startDate.getTime()) / 1000L + " seconds");
    }

    private static int runCtyExportTool(String networkName, String csvDataFile, String configInputMode, String vizMapPropsFile, String vizStyleName, String alternativeTableImportJsonFile, String cysOutFile, String htmlReportFile, String picturesPath, String logFile) throws Exception {
        if (CONFIG_INPUT_TEMPLATE.equals(configInputMode)) {
            vizMapPropsFile = Utils.getTempFileFromResource((String)vizMapPropsFile, (boolean)false);
            alternativeTableImportJsonFile = Utils.getTempFileFromResource((String)alternativeTableImportJsonFile, (boolean)false);
        }
        Utils.makeOutputFolderStructure((String)new File(cysOutFile).getParent());
        String newJsonFile = CytoExportTool.editJsonFileForDynamicAttributesAndRemoveUnnecessaryAttributes(csvDataFile, alternativeTableImportJsonFile);
        System.out.println("newJsonFile : " + newJsonFile);
        CytoExportTool thisTool = new CytoExportTool();
        thisTool.makeCysFile(networkName, csvDataFile, vizMapPropsFile, vizStyleName, newJsonFile, cysOutFile, htmlReportFile, picturesPath, logFile);
        return 1;
    }

    public static String editJsonFileForDynamicAttributesAndRemoveUnnecessaryAttributes(String csvDataFile, String alternativeTableImportJsonFile) throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        String jsonString = Utils.file2String((InputStream)new FileInputStream(alternativeTableImportJsonFile));
        JSONObject jsonObject = (JSONObject)parser.parse(jsonString);
        jsonObject.remove((Object)"tableFile");
        JSONArray dynamicTargetAttributes = (JSONArray)jsonObject.get((Object)"dynamicTargetAttributes");
        if (dynamicTargetAttributes == null) {
            return Utils.string2file((String)JSONValue.toJSONString((Object)jsonObject));
        }
        ArrayList<String> attributeNamesOrParts = new ArrayList<String>();
        for (Object dynamicTargetAttribute : dynamicTargetAttributes) {
            attributeNamesOrParts.add((String)dynamicTargetAttribute);
        }
        JSONObject dynamicTargetAttributesInterpretation = (JSONObject)jsonObject.get((Object)"dynamicAttributesInterpretation");
        CsvReader csvReader = new CsvReader(csvDataFile, 1);
        String[] csvHeaderFields = csvReader.getArrayOfHeaderNames(1);
        ArrayList<String> completeExtraAttributeNames = new ArrayList<String>();
        HashMap<String, String> completeExtraInterpretations = new HashMap<String, String>();
        for (String attributeNameOrPart : attributeNamesOrParts) {
            List<String> fieldNamesForPart = CytoExportTool.getFieldNamesForPrefix(attributeNameOrPart, csvHeaderFields);
            for (String fieldName : fieldNamesForPart) {
                completeExtraAttributeNames.add(fieldName);
                completeExtraInterpretations.put(fieldName, (String)dynamicTargetAttributesInterpretation.get((Object)attributeNameOrPart));
            }
        }
        JSONArray targetAttributes = (JSONArray)jsonObject.get((Object)"targetAttributes");
        JSONObject interpretationMap = (JSONObject)jsonObject.get((Object)"interpretation");
        for (String fieldName : completeExtraAttributeNames) {
            targetAttributes.add((Object)fieldName);
            if (completeExtraInterpretations.get(fieldName) == null) continue;
            interpretationMap.put((Object)fieldName, completeExtraInterpretations.get(fieldName));
        }
        jsonObject.remove((Object)"dynamicTargetAttributes");
        jsonObject.remove((Object)"dynamicAttributesInterpretation");
        return Utils.string2file((String)JSONValue.toJSONString((Object)jsonObject));
    }

    private static List<String> getFieldNamesForPrefix(String attributeNameOrPart, String[] csvHeaderFields) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = csvHeaderFields;
        int n = csvHeaderFields.length;
        int n2 = 0;
        while (n2 < n) {
            String headerField = stringArray[n2];
            if (attributeNameOrPart.length() > 0 && headerField.startsWith(attributeNameOrPart)) {
                result.add(headerField);
            }
            ++n2;
        }
        return result;
    }

    public CytoExportTool() throws PluginException, IOException {
        boolean dummyUIAvailable = true;
        Process linuxUiProc = null;
        if (!Utils.isWindows()) {
            linuxUiProc = this.prepareDummyScreen();
            boolean bl = dummyUIAvailable = linuxUiProc != null;
        }
        if (!dummyUIAvailable) {
            throw new RuntimeException("Could not initialize the X11 Xvfg for Cytoscape 2.8.3 headless mode");
        }
        CytoscapePlugin.loadPlugin(LayoutPlugin.class);
    }

    private Process prepareDummyScreen() throws IOException {
        String command = "Xvfb :995 ";
        try {
            String errorToIgnore = "Server is already active";
            Process proc = Utils.execCommand((String)command, (String)errorToIgnore, (boolean)false, (int)10000);
            Thread.sleep(500L);
            return proc;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void makeCysFile(String networkName, String csvDataFile, String vizMapPropsFile, String vizStyleName, String alternativeTableImportJsonFile, String cysOutFile, String htmlReportFile, String picturesPath, String logFile) throws IOException, URISyntaxException {
        if (vizStyleName == null || vizStyleName.length() == 0) {
            vizStyleName = "default";
        }
        PrintStream stdOut = System.out;
        PrintStream stdErr = System.err;
        System.setOut(new PrintStream(new File(logFile)));
        System.setErr(new PrintStream(new File(logFile)));
        try {
            File transactionsProfile = new File(alternativeTableImportJsonFile);
            SaveableSettings loadedSettings = SettingsPersistence.loadSettings((File)transactionsProfile);
            loadedSettings.setTableFile(new File(csvDataFile));
            if (networkName == null || networkName.length() == 0) {
                loadedSettings.setNetworkName(new File(csvDataFile).getName());
            } else {
                loadedSettings.setNetworkName(networkName);
            }
            CyNetwork newCyNetwork = NetworkCreator.createNetwork((SaveableSettings)loadedSettings, (boolean)true);
            CyNetworkView view = Cytoscape.getNetworkView((String)newCyNetwork.getIdentifier());
            String xgmmlFile = String.valueOf(cysOutFile) + ".xgmml";
            XGMMLWriter xgmmlWriter = new XGMMLWriter(view.getNetwork(), view);
            xgmmlWriter.write((Writer)new OutputStreamWriter(new FileOutputStream(xgmmlFile)));
            if (htmlReportFile != null && htmlReportFile.length() > 0) {
                this.makeNetworksPreviewReport(view, vizMapPropsFile, vizStyleName, htmlReportFile, picturesPath);
            }
            Utils.makeOutputFolderStructure((String)new File(cysOutFile).getParent());
            this.makeCysFileForXgmml(xgmmlFile, vizMapPropsFile, vizStyleName, cysOutFile);
        }
        finally {
            System.setOut(stdOut);
            System.setErr(stdErr);
        }
    }

    private void makeCysFileForXgmml(String xgmmlFile, String vizMapPropsFile, String vizStyleName, String cysOutFile) throws IOException {
        String rootFolder = "CytoscapeSession-Generated";
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        ArrayList<String> cysFilesList = new ArrayList<String>();
        InputStream cysessionXml = this.getClass().getResourceAsStream("/com/pri/cytoexport/resources/cysession.xml");
        String cysessionXmlString = Utils.file2String((InputStream)cysessionXml);
        cysessionXmlString = cysessionXmlString.replaceAll("visualStyle=\"default\"", "visualStyle=\"" + vizStyleName + "\"");
        inputStreams.add(new ByteArrayInputStream(cysessionXmlString.getBytes()));
        cysFilesList.add(String.valueOf(rootFolder) + "/cysession.xml");
        inputStreams.add(this.getClass().getResourceAsStream("/com/pri/cytoexport/resources/session_bookmarks.xml"));
        cysFilesList.add(String.valueOf(rootFolder) + "/session_bookmarks.xml");
        inputStreams.add(this.getClass().getResourceAsStream("/com/pri/cytoexport/resources/session_cytoscape.props"));
        cysFilesList.add(String.valueOf(rootFolder) + "/session_cytoscape.props");
        inputStreams.add(new FileInputStream(xgmmlFile));
        cysFilesList.add(String.valueOf(rootFolder) + "/galaxy_generated_network.xgmml");
        inputStreams.add(new FileInputStream(vizMapPropsFile));
        cysFilesList.add(String.valueOf(rootFolder) + "/session_vizmap.props");
        ZipWriter.zip(cysFilesList, inputStreams, (File)new File(cysOutFile), (boolean)false);
    }

    private void makeNetworkPictureFile(CyNetworkView view, String vizMapPropsFile, String vizStyleName, String networkPicturePNGOutFileName) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        props.load(new FileReader(vizMapPropsFile));
        CalculatorCatalog catalog = new CalculatorCatalog();
        CalculatorIO.loadCalculators((Properties)props, (CalculatorCatalog)catalog);
        VisualMappingManager vizman = new VisualMappingManager(view);
        VisualStyle visualStyle = catalog.getVisualStyle(vizStyleName);
        vizman.setVisualStyle(visualStyle);
        vizman.applyAppearances();
        view = vizman.getNetworkView();
        CustomBitmapExporter bmpExporter = new CustomBitmapExporter("png", 0.1);
        bmpExporter.export(view, new FileOutputStream(String.valueOf(networkPicturePNGOutFileName) + ".png"));
        CustomSVGExporter svgExporter = new CustomSVGExporter();
        svgExporter.export(view, new FileOutputStream(networkPicturePNGOutFileName));
    }

    private void makeNetworksPreviewReport(CyNetworkView view, String vizMapPropsFile, String vizStyleName, String htmlReportFile, String picturesPath) throws FileNotFoundException, IOException {
        if (picturesPath == null || picturesPath.length() == 0) {
            throw new RuntimeException("The argument picturesPath is mandatory is the htmlReportFile argument is set");
        }
        Utils.makeOutputFolderStructure((String)picturesPath);
        int netWorkNr = 1;
        ArrayList<String> pictureFiles = new ArrayList<String>();
        try {
            String networkPicturePNGOutFileName = String.valueOf(picturesPath) + "/net_" + netWorkNr + ".svg";
            this.makeNetworkPictureFile(view, vizMapPropsFile, vizStyleName, networkPicturePNGOutFileName);
            pictureFiles.add(new File(networkPicturePNGOutFileName).getName());
        }
        catch (Exception e) {
            pictureFiles.add("ERROR: " + Utils.getStackTraceString((Throwable)e));
        }
        CytoExportReport report = new CytoExportReport(htmlReportFile, "");
        report.writeHTMLOutput(pictureFiles);
    }
}

