/*
 * Decompiled with CFR 0.152.
 */
package com.pri.cytoexport.tool;

import com.pri.general.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class CytoExportReport {
    private static final String ERROR = "ERROR";
    private String outReport;
    private String workingDir;
    private String logAndWarnings;

    public CytoExportReport(String reportFile, String logAndWarnings) {
        this.outReport = reportFile;
        this.workingDir = new File(new File(reportFile).getParent()).getAbsolutePath();
        this.logAndWarnings = logAndWarnings;
        Utils.makeOutputFolderStructure((String)this.workingDir);
    }

    public void writeHTMLOutput(List<String> pictureFiles) throws IOException {
        try (FileWriter writerHtml = null;){
            writerHtml = new FileWriter(this.outReport);
            String html = "<html><body style=\"font-family: arial,verdana,helvetica,sans-serif;\"><h3>Pictures of the networks</h3><table style='border=0;font-size:12'>\n<tr><td>Nr networks: </td><td>" + pictureFiles.size() + "</td><td>(total nr of networks generated)</td></tr>\n" + "</table></br>\n";
            int i = 0;
            while (i < pictureFiles.size()) {
                html = pictureFiles.get(i).startsWith(ERROR) ? String.valueOf(html) + "<p style='font-size:12'>" + pictureFiles.get(i) + "</p>\n" : String.valueOf(html) + "<a href='" + pictureFiles.get(i) + "' target='_blank'><img style='border:1px solid #021a40; width: 700px; height: 700px;' src='" + pictureFiles.get(i) + ".png" + "'></img></a>\n";
                ++i;
            }
            html = String.valueOf(html) + "<h3>Other tool log/stats/warnings</h3></br>\n<p style='font-size:12'>\n" + this.logAndWarnings.replaceAll("\\n", "</br>\n") + "</p></br>\n";
            html = String.valueOf(html) + "</body></html>";
            writerHtml.write(html);
        }
    }
}

