/*
 * Decompiled with CFR 0.152.
 */
package com.pri.cytoexport.cytoscape.temp;

import cytoscape.ding.DingNetworkView;
import cytoscape.view.CyNetworkView;
import cytoscape.view.InternalFrameComponent;
import ding.view.DGraphView;
import giny.view.NodeView;
import java.awt.Dimension;
import java.util.Iterator;
import javax.swing.JLayeredPane;

public class CustomInternalView {
    public static InternalFrameComponent createInternalComponent(CyNetworkView view) {
        Dimension d = CustomInternalView.getDimension(view);
        int w = (int)d.getWidth();
        int h = (int)d.getHeight();
        ((DingNetworkView)view).setCenter((double)((w - 150) / 2), (double)((h - 150) / 2));
        return CustomInternalView.createInternalComponent(view, w, h, true);
    }

    public static InternalFrameComponent createInternalComponent(CyNetworkView view, int width, int height) {
        return CustomInternalView.createInternalComponent(view, width, height, true);
    }

    public static InternalFrameComponent createInternalComponent(CyNetworkView view, int width, int height, boolean autoZoom) {
        JLayeredPane pane = new JLayeredPane();
        pane.setSize(width, height);
        InternalFrameComponent ifc = new InternalFrameComponent(pane, (DGraphView)view);
        ifc.setBounds(0, 0, width, height);
        if (autoZoom) {
            CustomInternalView.zoom(view, width, height);
        }
        return ifc;
    }

    private static void zoom(CyNetworkView view, int width, int height) {
        Dimension d = CustomInternalView.getDimension(view);
        double h = d.getHeight();
        double w = d.getWidth();
        double scale = Math.min((double)width / w, (double)height / h);
        view.setZoom(scale);
    }

    public static Dimension getDimension(CyNetworkView view) {
        Iterator nodeviews = view.getNodeViewsIterator();
        double w = 0.0;
        double h = 0.0;
        while (nodeviews.hasNext()) {
            NodeView nv = (NodeView)nodeviews.next();
            w = Math.max(w, nv.getXPosition() + nv.getWidth() + 150.0);
            h = Math.max(h, nv.getYPosition() + nv.getHeight() + 150.0);
        }
        return new Dimension((int)w, (int)h);
    }

    public static InternalFrameComponent getInternalComponent(CyNetworkView view) {
        return CustomInternalView.createInternalComponent(view);
    }
}

