#!/usr/bin/env Rscript
argspec <- c("remove.tcga.normals.R removes TCGA normal samples from a given matrix

        Usage: 
                remove.tcga.normals.R -d <data.file> 
        Optional:
                                           -o <output_file>
                \n\n")
args <- commandArgs(TRUE)
if ( length( args ) == 1 && args =="--help") { 
  write(argspec, stderr())
  q();
}

lib.load.quiet <- function( package ) {
   package <- as.character(substitute(package))
   suppressPackageStartupMessages( do.call( "library", list( package=package ) ) )
}
lib.load.quiet(getopt)

spec <- matrix( c( "data.fname",      "d", 1, "character",
                   "output.fname",    "o", 2, "character"
                   ),
                nc=4,
                byrow=TRUE
               )

opt <- getopt( spec=spec )
if ( is.null( opt$output.fname ) ) { opt$output.fname <- 'merge_merge.tumors.tab' }

mat <- as.matrix( read.delim( opt$data.fname, row.names=1, check.names=FALSE ) )
if ( length( strsplit( colnames( mat ), "-" )[[1]] ) == 4 ) {
  cnames <-  sapply( strsplit( colnames( mat ), "-" ), function(x) x[4] )
  norms <- grepl( "^1", cnames )

  if ( sum( norms ) > 0  ) {
    tumors <- ! norms
    mat <- mat[, tumors ]
  }
}
write.table( mat, opt$output.fname, quote=FALSE, sep="\t", col.names=NA )
