#!/usr/bin/env Rscript
argspec <- c("remove.degenerate.values.R replaces degenerate values (NaNs & Infs) with a user-specified value

        Usage: 
                remove.degenerate.values.R -d <data.file> 
        Optional:
                                           -o <output_file>
                \n\n")
args <- commandArgs(TRUE)
if ( length( args ) == 1 && args =="--help") { 
  write(argspec, stderr())
  q();
}

lib.load.quiet <- function( package ) {
   package <- as.character(substitute(package))
   suppressPackageStartupMessages( do.call( "library", list( package=package ) ) )
}
lib.load.quiet(getopt)

spec <- matrix( c( "data.fname",      "d", 1, "character",
                   "output.fname",    "o", 2, "character"
                   ),
                nc=4,
                byrow=TRUE
               )

opt <- getopt( spec=spec )
if ( is.null( opt$output.fname ) ) { opt$output.fname <- 'merge_merge.reals.tab' }

mat <- as.matrix( read.delim( opt$data.fname, row.names=1, check.names=FALSE ) )
cnames <-  sapply( strsplit( colnames( mat ), "\\s+" ), function(x) x[1] )
colnames( mat ) <- cnames
nulls <- mat[ , grepl( "^na", cnames ) ]
reals <- mat[ , !grepl( "^na", cnames ) ]

reals <- cbind( rownames( reals ), reals ); rownames( reals ) <- NULL
reals <- rbind( colnames( reals ), reals ); colnames( reals ) <- NULL
reals[1,1] <- "ID"
write.table( reals, opt$output.fname, quote=FALSE, sep="\t", row.names=FALSE, col.names=FALSE )
