#!/usr/bin/env Rscript
argspec <- c("tab.2.cdt.R converts a data matrix to cdt format

        Usage: 
                tab.2.cdt.R -d <data.file> 
        Optional:
                            -o <output_file>
                \n\n")
args <- commandArgs(TRUE)
if ( length( args ) == 1 && args =="--help") { 
  write(argspec, stderr())
  q();
}


lib.load.quiet <- function( package ) {
   package <- as.character(substitute(package))
   suppressPackageStartupMessages( do.call( "library", list( package=package ) ) )
}
lib.load.quiet(getopt)


spec <- matrix( c( "data.fname",      "d", 1, "character",
                   "output.fname",    "o", 2, "character"
                   ),
                nc=4,
                byrow=TRUE
               )

opt <- getopt( spec=spec )
if ( is.null( opt$output.fname ) ) opt$output.fname <- sub( "tab$|csv$", "cdt", opt$data.fname )

data <- as.matrix( read.delim( opt$data.fname, row.names=1, check.names=FALSE ) )
cnames <- colnames( data )
data <- cbind( data[,1], data[,1], rep(1,nrow(data) ), data[, 2:ncol(data)] )
data <- rbind( c( "EWEIGHT", "", NA,
                  rep( 1, length( cnames[-1] ) ) ),
               data )
colnames( data ) <- c( "UNIQID", "NAME", "GWEIGHT", cnames[-1] )
data <- rbind( colnames( data ), data )
colnames( data ) <- NULL

write.table( data, opt$output.fname, sep="\t", row.names=FALSE, col.names=FALSE, quote=FALSE )
