#!/usr/bin/env Rscript
argspec <- c("remove.degenerate.values.R replaces degenerate values (NaNs & Infs) with a user-specified value

        Usage: 
                remove.degenerate.values.R -d <data.file> 
        Optional:
                                           -r <replacement_value> (default is NA)
                                           -o <output_file>
                \n\n")
args <- commandArgs(TRUE)
if ( length( args ) == 1 && args =="--help") { 
  write(argspec, stderr())
  q();
}

lib.load.quiet <- function( package ) {
   package <- as.character(substitute(package))
   suppressPackageStartupMessages( do.call( "library", list( package=package ) ) )
}
lib.load.quiet(getopt)

spec <- matrix( c( "data.fname",      "d", 1, "character",
                   "replacement.val", "r", 2, "character",
                   "output.fname",    "o", 2, "character"
                   ),
                nc=4,
                byrow=TRUE
               )

opt <- getopt( spec=spec )

data <- as.matrix( read.delim( opt$data.fname, row.names=1, check.names=FALSE ) )
if ( is.null( opt$replacement.val ) ) { opt$replacement.val <- NA }
if ( ! is.null( opt$replacement.val ) ) { opt$replacement.val <- as.integer( opt$replacement.val ) }
if ( is.null( opt$output.fname ) ) { opt$output.fname <- paste( "degenerate.vals.replaced", basename( opt$data.fname ), sep="." ) }

## Set any NA, NAN or Inf entries to 0
if ( any(is.nan(data)) ) data[ is.nan( data ) ] <- opt$replacement.val
if ( any(is.infinite(data)) ) data[ is.infinite( data ) ] <- opt$replacement.val

write.table( data, opt$output.fname, sep="\t", quote=FALSE, col.names=NA )
