#!/usr/bin/env Rscript
argspec <- c("impute.knn.R replaces missing values, using the impute.knn function from the impute package

        Usage: 
                impute.knn.R -d <data.file> 
        Optional:
                             -o <output_file>
                \n\n")
args <- commandArgs(TRUE)
if ( length( args ) == 1 && args =="--help") { 
  write(argspec, stderr())
  q();
}

lib.load.quiet <- function( package ) {
   package <- as.character(substitute(package))
   suppressPackageStartupMessages( do.call( "library", list( package=package ) ) )
}
lib.load.quiet(getopt)
lib.load.quiet( impute )

spec <- matrix( c( "data.fname",      "d", 1, "character",
                   "output.fname",    "o", 2, "character"
                   ),
                nc=4,
                byrow=TRUE
               )

opt <- getopt( spec=spec )

data <- as.matrix( read.delim( opt$data.fname, row.names=1, check.names=FALSE ) )
if ( is.null( opt$replacement.val ) ) { opt$replacement.val <- NA }
if ( is.null( opt$output.fname ) ) { opt$output.fname <- paste( "impute.knn", basename( opt$data.fname ), sep="." ) }

  ## Set any NA, NAN or Inf entries to 0
if ( is.nan(data) ) {
  data[ is.nan( data ) ] <- NA
}
if ( is.infinite(data) ) {
  data[ is.infinite( data ) ] <- NA
}

data <- impute.knn( data )$data
write.table( data, opt$output.fname, sep="\t", quote=FALSE, col.names=NA )
