#!/usr/bin/env bash
if [ x$BASH = x ] || [ ! $BASH_VERSINFO ] || [ $BASH_VERSINFO -lt 4 ]; then
  echo "Error: Must use bash version 4+." >&2
  exit 1
fi
set -ue

TmpSscsBefore="tmp.sscs.before.fa"
TmpSscsAfter="tmp.sscs.after.fa"
TmpMsa="tmp.family.msa.tsv"

Usage="Usage: \$ $(basename $0) diff.family.msa.tsv diff.sscs.before.fa diff.sscs.after.fa > cmp.txt"

function main {
  if [[ $# -lt 3 ]] || [[ $1 == '-h' ]]; then
    fail "$Usage"
  else
    msa_input="$1"
    sscs_before="$2"
    sscs_after="$3"
  fi

  lines=$(cat $sscs_before | wc -l)
  choice=$(python -c "import random; print 2*random.randint(1, $lines/2)")

  echo $lines $choice >&2

  head -n $choice $sscs_before | tail -n 2 > $TmpSscsBefore
  head -n $choice $sscs_after | tail -n 2 > $TmpSscsAfter
  cat $msa_input | ../msa_sscs_matcher.py $TmpSscsBefore > $TmpMsa

  tail -n +2 $TmpSscsBefore
  tail -n +2 $TmpSscsAfter
  echo
  cut -f 5,6 $TmpMsa
}

function fail {
  echo "$@" >&2
  exit 1
}

main "$@"
