# xcms.r version 20130418

library(xcms)
library(batch) #necessary for parseCommandArgs function
library(CAMERA)

source("/w/galaxy/tools/prod/abims/xcms.20130418/tcis.r")

listArguments = parseCommandArgs(evaluate=FALSE) #interpretation of arguments given in command line as an R list of objects
print(listArguments)

#image is an .RData file necessary to use xset variable given by previous tools
if (!is.null(listArguments[["image"]])){
    load(listArguments[["image"]])
    listArguments[["image"]]=NULL
}

#saving the name of the function in a variable thefunction
thefunction = listArguments[["xfunction"]]
listArguments[["xfunction"]]=NULL #delete from the list of arguments

#necessary to unzip .zip file uploaded to Galaxy
#thanks to .zip file it's possible to upload many file as the same time conserving the tree hierarchy of directories
if (!is.null(listArguments[["input"]])) {
    directory=unzip(listArguments[["input"]])
    if (thefunction == "xcmsSet") {
        listArguments=append(list(directory), listArguments)
    }
    listArguments[["input"]]=NULL
}

#addition of xset object to the list of arguments in the first position
if (length(ls(pattern="^xset$")) != 0){
    listArguments=append(list(xset), listArguments)
}

#change the default display settings
dev.new(width=16, height=12)
if (thefunction == "group") {
    par(mfrow=c(2,2))
} else if (thefunction == "retcor") {
#try to change the legend display
#~     par(xpd=NA)
#~     par(xpd=T, mar=par()$mar+c(0,0,0,4))
}

##################################
if (thefunction %in% c("diffreport", "annotateDiffreport")) {
	classes=levels(sampclass(xset))
    x=1:(length(classes)-1)
    for (i in seq(along=x) ) {
        y=1:(length(classes))
        for (n in seq(along=y)){
            if(i+n <= length(classes)){
                listArguments[["class1"]]=classes[i]
                listArguments[["class2"]]=classes[i+n]
                listArguments[["filebase"]]=paste(listArguments[["class1"]],listArguments[["class2"]], sep="_vs_")
                save.image(paste("debug","RData",sep="."))
                diffreport = do.call(thefunction, listArguments)
            }
        }
    }
    system(paste('ls . | grep -e "tsv$" -e "box$" -e "eic$" | zip -r -@ "Xdiffreport.zip" '))
    write.table(diffreport, sep="\t", quote=FALSE, col.names=NA, file="Xdiffreport.tsv")
    statmatrix = diffreport[,(names(diffreport) %in% c("name", sampnames(xset)))]
    write.table(statmatrix, sep="\t", quote=FALSE, row.names=FALSE, file="Xdiffreport.data_matrix.tsv")
###
} else {
    #execution of the function "thefunction" with the parameters given in "listArguments"
    xset = do.call(thefunction, listArguments)
    print(xset)
    #transform the files absolute pathways into relative pathways
    xset@filepaths<-sub("^.*/database/job_working_directory/[0123456789]+/[0123456789]+/" ,"", xset@filepaths)
}

if (thefunction == "xcmsSet") {
	write.table(xset@phenoData, sep="\t", quote=FALSE, col.names=NA, file="sample_info.tab")
    getTICs(xcmsSet=xset, pdfname="TICs_raw.pdf",rt="raw")
} else if (thefunction == "retcor") {
    getTICs(xcmsSet=xset, pdfname="TICs_corrected.pdf",rt="corrected")
}

#delete the parameters to avoid the passage to the next tool in .RData image
rm(listArguments)

#saving R data in .Rdata file to save the variables used in the present tool
save.image(paste(thefunction,"RData",sep="."))
