"""
XCMS datatypes
"""

import logging
import os,os.path,re
import galaxy.datatypes.data
from galaxy.datatypes.data import Data
from galaxy.datatypes.binary import Binary
from galaxy.datatypes.metadata import MetadataElement

log = logging.getLogger(__name__)

class RData( Binary ):
    """
    A R session Image
    """
    
    file_ext = 'rdata'
    is_binary = True
    
    

class MSZip( Data ):
    """
    A zip container for xcms input files
    """
    
    file_ext = 'ms_zip'
    is_binary = False
    
    def sniff( self, filename ):
        """
        Check REAL file name (dataset.name) and NOT tmp file name (dataset.path) for ".ms.zip" extension
        """
        try:
            return (filename[-7:] == '.ms.zip')
        except:
            return False
    
    
    
    
    
    
    
    
    



