zz = file("warnings_and_errors.txt")
sink(zz)
sink(zz, type = "message")


# bring user inputs and command line arguments to R
spec_matrix = as.matrix(
  data.frame(stringsAsFactors=FALSE,
             long_flags = c("X_e", "X_A", "X_B", "X_O", "X_r", "X_d", "X_s",
                            "X_t"),
             short_flags = c("e", "A", "B", "O", "r", "d", "s", "t"),
             argument_mask_flags = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L),
             data_type_flags = c("character", "character", "character", "character",
                                 "character", "character", "character",
                                 "character")
  )
)
opt = getopt::getopt(spec_matrix)
opt

# build command: awk '{print $1,$2}' > output.txt and run
X_A = paste0(paste0('$', trimws(strsplit(opt$X_A, ',')[[1]])), collapse = ',')
extract_field_command = paste0("awk '{print ", X_A, " }' ", opt$X_B, " > ", opt$X_O)
system(command = extract_field_command)

rmarkdown::render(input = opt$X_t, output_file = opt$X_r)
sink()
