#!/usr/bin/Rscript --vanilla --slave --no-site-file

################################################################################################
# WRAPPER FOR IDchoice_script.R (ID CHOICE)                                                    #
#                                                                                              #
# Author: Melanie PETERA                                                                       #
# User: Galaxy                                                                                 #
# Original data: used with IDchoice_script.R                                                   #
# Starting date: 01-06-2017                                                                    #
# V-1: First version of wrapper                                                                #
# V-2: Additional information in stdout                                                        #
#                                                                                              #
#                                                                                              #
# Input files: dataMatrix ; Metadata file                                                      #
# Output files: dataMatrix ; Metadata file                                                     #
#                                                                                              #
################################################################################################


library(batch) #necessary for parseCommandArgs function
args = parseCommandArgs(evaluate=FALSE) #interpretation of arguments given in command line as an R list of objects

source_local <- function(...){
	argv <- commandArgs(trailingOnly = FALSE)
	base_dir <- dirname(substring(argv[grep("--file=", argv)], 8))
	for(i in 1:length(list(...))){source(paste(base_dir, list(...)[[i]], sep="/"))}
}
#Import the different functions
source_local("IDchoice_script.R","easyrlibrary-lib/RcheckLibrary.R","easyrlibrary-lib/miniTools.R")


if(length(args) < 7){ stop("NOT enough argument !!!") }


cat('\nJob starting time:\n',format(Sys.time(), "%a %d %b %Y %X"),
'\n\n--------------------------------------------------------------------', 
'\nParameters used in "ID choice":\n\n')
print(args)
cat('--------------------------------------------------------------------\n\n')


id.choice(args$dataMatrix_in, args$Metadata_in, args$metatype, args$col_name, args$makeunique, args$DM_out, args$meta_out)


cat('\n--------------------------------------------------------------------',
'\nInformation about R (version, Operating System, attached or loaded packages):\n\n')
sessionInfo()
cat('--------------------------------------------------------------------\n',
'\nJob ending time:\n',format(Sys.time(), "%a %d %b %Y %X"))


#delete the parameters to avoid the passage to the next tool in .RData image
rm(args)
