#!/usr/bin/Rscript --vanilla --slave --no-site-file

################################################################################################
# WRAPPER FOR Corr_Script_samples_row.R (CORRELATION TABLE)                                    #
#                                                                                              #
# Author: Ophelie BARBET                                                                       #
# Maintainer: Melanie PETERA                                                                   #
# User: Galaxy                                                                                 #
# Original data: used with Corr_Script_samples_row.R                                           #
# Starting date:                                                                               #
# V-1: First version of wrapper                                                                #
# V-2: Corresponds to XML version 1.0.0                                                        #
#                                                                                              #
#                                                                                              #
# Input files: 2 tables with common samples file                                               #
# Output files: Correlation table ; Heatmap file                                               #
#                                                                                              #
################################################################################################


library(batch) #necessary for parseCommandArgs function
args = parseCommandArgs(evaluate=FALSE) #interpretation of arguments given in command line as an R list of objects

source_local <- function(...){
	argv <- commandArgs(trailingOnly = FALSE)
	base_dir <- dirname(substring(argv[grep("--file=", argv)], 8))
	for(i in 1:length(list(...))){source(paste(base_dir, list(...)[[i]], sep="/"))}
}
#Import the different functions
source_local("Corr_Script_samples_row.R")


if(length(args) < 10){ stop("NOT enough argument !!!") }


cat('\n--------------------------------------------------------------------', 
'\nParameters used in "Between-table Correlation":\n\n')
print(args)
cat('--------------------------------------------------------------------\n\n')


risk_alpha <- NULL
correct_multi <- NULL
if(args$test_corr == "yes"){
	risk_alpha <- args$risk_alpha
	correct_multi <- args$correct_multi
}

filters_choice <- NULL
threshold <- NULL
if(args$filter == "yes"){
	filters_choice <- args$filters_choice
	if(filters_choice == "filters_0_thr"){
		threshold <- args$threshold
	}	
}

type_classes <- NULL
reg_class_value <- NULL
irreg_class_vect <- NULL
if(args$plot_choice == "none"){args$color_heatmap <- "no"; args$heatmap_out <- NULL}
if(args$color_heatmap == "yes"){
	type_classes <- args$type_classes
	if(type_classes == "regular"){
		reg_class_value <- args$reg_class_value
	} else if(type_classes == "irregular"){
		irreg_class_vect <- eval(parse(text=paste0("c",args$irreg_class_vect)))		
	}
}	


correlation.tab(args$tab1_in, args$tab2_in, args$tab1_samples, args$tab2_samples, args$corr_method, args$test_corr, risk_alpha, correct_multi, args$filter, filters_choice, threshold,
args$reorder_var, args$plot_choice, args$color_heatmap, type_classes, reg_class_value, irreg_class_vect, args$tabcorr_out, args$heatmap_out)


cat('\n--------------------------------------------------------------------',
'\nInformation about R (version, Operating System, attached or loaded packages):\n\n')
sessionInfo()
cat('--------------------------------------------------------------------\n\n')


#delete the parameters to avoid the passage to the next tool in .RData image
rm(args)