#! /usr/bin/perl

# Copyright 2009 Matteo Cesaroni, Lucilla Luzi
#
# This program is free software; ; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at your
# option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.


$file_all=$ARGV[0];
$file_sub=$ARGV[1];
$down=$ARGV[2];
$up=$ARGV[6];
$scelta=$ARGV[3];
$result=$ARGV[4];
$output=$ARGV[5];


open(FILESUB, "<$file_sub") or die "Cannot find file $file_sub\n";
open(FILEALL, "<$file_all") or die "Cannot open file $file_all: $!\n";
open(FILEOUT, ">$output") or die "Cannot create file $output: $!\n";

print "Analysis Type=$scelta, Promoter def:$down/$up, output=$result\n";

@sub=<FILESUB>;
@all=<FILEALL>;
foreach $lines_all(@all){
	chomp $lines_all;
	#chop $lines_all;
	if ($lines_all=~/#/g){next;}
	@line_all=split("\t",$lines_all);
	$chr=$line_all[2];
	$refseq=$line_all[1];
	$refStart=$line_all[3];
	$refStop=$line_all[4];
	$name=$line_all[0];
	#$exon_count=$line_all[8];
	#@exonStart=split(",",$line_all[9]);
	#@exonStop=split(",",$line_all[10]);
	$strand=$line_all[5];
	if ($scelta eq "promoter"){
		if ($strand eq "+"){
			$prom_start=$refStart+$down;
			$prom_stop=$refStart+$up;
		}
		if ($strand eq "-"){
			$prom_start=$refStop-$up;
			$prom_stop=$refStop-$down;
		}
	}
	if ($scelta eq "all"){
		if ($strand eq "+"){
			$prom_start=$refStart+$down;
			$prom_stop=$refStop;
		}
		if ($strand eq "-"){
			$prom_start=$refStart;
			$prom_stop=$refStop-$down;
		}
	}
	
	
	
	@promotore=();
	$max_prom=0;
	foreach $lines_sub(@sub){
		chomp $lines_sub;
		if ($lines_sub=~/#/g){next;}
		@line_sub=split("\t",$lines_sub);
		$chr_p=$line_sub[0];
		$peakStart=$line_sub[3];
		$peakStop=$line_sub[4];
		$value=$line_sub[5];
		#print "$peakStart\t$peakStop\t$prom_start\t$prom_stop\n";
		#print "$refStart\t$refStop\t$peakStart\t$peakStop\n";
		if (((($peakStart>=$prom_start) && ($peakStart<=$prom_stop)) || (($peakStart<=$prom_start) && ($peakStop>=$prom_start))) && ("$chr" eq "$chr_p")){
			push(@promotore,$value);
			#print "cazzo";
			
		}
	}
	$i=0;
	foreach $valore(@promotore){
		$i++;
		if($max_prom<$valore){
			$max_prom=$valore;
		}
	}
	if ($result eq "max_value"){
		print FILEOUT "$lines_all\t$max_prom\n";
	}
	else{
		print FILEOUT "$lines_all\t$i\n";
	}
}
