#!/usr/bin/env python

import sys
import csv

class ClinicalMatrix:
    corner_name = "sample"
    def load(self, path):
        self.col_map = {}
        self.row_map = {}    
        pos_hash = None

        handle = open(path)
        
        self.matrix = []
        for row in csv.reader(handle, delimiter="\t"):
            if pos_hash is None:
                pos_hash = {}
                pos = 0
                for name in row[1:]:
                    i = 1
                    orig_name = name
                    while name in pos_hash:
                        name = orig_name + "#" + str(i)
                        i += 1
                    pos_hash[name] = pos
                    pos += 1
            else:
                newRow = []
                newRow = [""] * (len(pos_hash))
                for col in pos_hash:
                    i = pos_hash[col] + 1
                    newRow[i - 1] = row[i]
                self.row_map[row[0]] = len(self.matrix)
                self.matrix.append(newRow)

        self.col_map = {}
        for col in pos_hash:
            self.col_map[col] = pos_hash[col]
    
    def get_row_list(self):
        """
        Returns names of rows
        """
        out = self.row_map.keys()
        out.sort( lambda x,y: self.row_map[x]-self.row_map[y])
        return out 

    def get_col_list(self):
        """
        Returns names of columns
        """
        out = self.col_map.keys()
        out.sort( lambda x,y: self.col_map[x]-self.col_map[y])
        return out 

    def get_row(self, row_name):
        return self.matrix[ self.row_map[row_name] ]
        
    def set_val(self, col_name, row_name, value):
        """
        Set cell value based on row and column names
        """
        self.matrix[self.row_map[row_name]][self.col_map[col_name]] = value
    
    def get_val(self, col_name, row_name):
        """
        Get cell value based on row and column names
        """
        return self.matrix[self.row_map[row_name]][self.col_map[col_name]]
        
        
    def init_blank(self, cols, rows):
        """
        Initlize matrix with NA (or nan) values using row/column names
        provided by user. User can also force usage of native python objects
        (which is useful for string based matrices, and numpy matrices fix cel string length)
        """       
        self.matrix = []
        self.col_map = {}
        self.row_map = {}    
        for i in range(len(rows)):
            self.matrix.append([""]*len(cols))
        for i, c in enumerate(cols):
            self.col_map[c] = i
        for i, r in enumerate(rows):
            self.row_map[r] = i
        self.loaded = True

    def write(self, handle, missing=''):
        write = csv.writer(handle, delimiter="\t", lineterminator='\n')
        col_list = self.get_col_list()
        
        write.writerow([self.corner_name] + col_list)
        for rowName in self.row_map:
            out = [rowName]
            row = self.get_row(rowName)
            for col in col_list:
                val = row[self.col_map[col]]
                out.append(val)
            write.writerow(out)

    def merge(self, other):
        rows = {}
        #get the rows that part of the original matrix
        for r in self.get_row_list():
            rows[r] = None
        if other is not None:
            for r in other.get_row_list():
                rows[r] = None
        cols = {}
        #get the cols that part of the original matrix
        for r in self.get_col_list():
            cols[r] = None
        if other is not None:
            for r in other.get_col_list():
                cols[r] = None
        out = ClinicalMatrix()
        out.init_blank(cols=cols, rows=rows)
        for row in self.get_row_list():
            for col in self.get_col_list():
                out.set_val(col_name=col, row_name=row, value=self.get_val(col_name=col, row_name=row))
        if other is not None:
            for row in other.get_row_list():
                for col in other.get_col_list():
                    out.set_val(col_name=col, row_name=row, value=other.get_val(col_name=col, row_name=row))
        return out


if __name__ == "__main__" : 
	
	matrix = None
	for p in sys.argv[1:]:
		nmatrix = ClinicalMatrix()
		nmatrix.load(p)
		matrix = nmatrix.merge(matrix)
	
	matrix.write(sys.stdout, missing="")

