#!/usr/bin/env python

import os
import sys
import csv
import re
import math
import argparse
import floatMatrix

def value_eval(code, value):
    funcmap = {
        "len":len,
        "value" : value,
        "re" : re,
        "math" : math,
        "sum" : sum,
        "float" : float
    }
    return eval(code,{"__builtins__":None},funcmap)

def dict_dict_2_table(indata):
    all_labels = {}
    for r in indata:
        for c in indata[r]:
            all_labels[c] = True
    head = all_labels.keys()
    out = []
    out.append( ["#"] + head )
    for r in indata:
        o = [r]
        for h in head:
            o.append( str(indata[r].get(h,"")) )
        out.append(o)
    return out


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-c', '--col-eval', help='Column Eval', dest="col_eval", default=None)
    parser.add_argument('-r', '--row-eval', help='Row Eval', dest="row_eval", default=None)
    
    parser.add_argument("-o", "--out", help="Output File", dest="output", default=None)
    parser.add_argument("input", help="Input Matrix", default=None)
    
    args = parser.parse_args()

    if args.input == "-":
        ihandle = sys.stdin
    else:
        ihandle = open(args.input)

    if args.output is None:
        ohandle = sys.stdout
    else:
        ohandle = open(args.output, "w")

    matrix = floatMatrix.FloatMatrix()
    matrix.read(ihandle)
    ihandle.close()

    out = {}

    if args.col_eval is not None and len(args.col_eval):
        for col in matrix.get_cols():
            value = matrix.get_col(col)
            out[col] = value_eval(args.col_eval, value)
        table = dict_dict_2_table(out)
        writer = csv.writer(ohandle, delimiter="\t", lineterminator="\n")
        for i in range(len(table[0])):
            o = []
            for r in table:
                o.append(r[i])
            writer.write_row(o)
    elif args.row_eval is not None and len(args.row_eval):
        for row in matrix.get_rows():
            value = matrix.get_row(row)
            out[row] = value_eval(args.row_eval, value)
        table = dict_dict_2_table(out)
        writer = csv.writer(ohandle, delimiter="\t", lineterminator="\n")
        writer.writerows(table)
    ohandle.close()


