#!/usr/bin/env python

import sys
import time
import array
import csv
import math
import ctypes
import ctypes.util
import argparse



if __name__ == "__main__":

    parser = argparse.ArgumentParser()
    parser.add_argument("-i", "--input", help="Input", default=None)        
    parser.add_argument("-o", "--output", help="Output", default=None)  

    parser.add_argument("-b", dest="bounds", help="Boundaries", type=float, nargs="*", default=None)
    parser.add_argument("-v", dest="vals", help="Group Values", nargs="*", default=None)

    args = parser.parse_args()

    if len(args.bounds) != len(args.vals) - 1:
        sys.stderr.write("Number of groups created by boundaries and group values does not match\n")
        sys.exit(1)

    head = True
    ihandle = open(args.input)
    ohandle = open(args.output, "w")
    for line in ihandle:
        if head:
            ohandle.write(line)
            head = False
        else:
            row = line.rstrip().split("\t")
            out = [row[0]]
            for a in row[1:]:
                v = float(a)
                if v <= args.bounds[0]:
                    o = args.vals[0]
                if v > args.bounds[-1]:
                    o = args.vals[-1]
                for i in range(1, len(args.bounds)):
                    if v > args.bounds[i-1] and v <= args.bounds[i]:
                        o = args.vals[i]
                out.append(o)
            ohandle.write("%s\n" % ("\t".join(out)))
    ihandle.close()
    ohandle.close()

