#!/usr/bin/env python

import sys
import argparse
import array
import math
import csv
import floatMatrix

def value_eval(code, values, label, label_set):
    funcmap = {
        "values" : values,
        "label" : label,
        "label_set" : label_set,
    }
    builtins = {
        "math" : math,
        "list" : list,
        "sum" : sum,
        "min" : min,
        "max" : max,
        "len" : len,
        "True" : True,
        "False" : False
    }
    return eval(code,{"__builtins__": builtins},funcmap)
         

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-c', '--col-filter', help='Column Filter', dest="col_filter", default=None)
    parser.add_argument('--col-filter-file', help='Column Filter File', default=None)
    parser.add_argument('-r', '--row-filter', help='Row Filter', dest="row_filter", default=None)
    parser.add_argument('--row-filter-file', help='Row Filter File', default=None)
    
    parser.add_argument("-o", "--out", help="Output File", dest="output", default=None)
    parser.add_argument("input", help="Input Matrix", default=None)
    
    args = parser.parse_args()

    if args.input == "-":
        handle = sys.stdin
    else:
        handle = open(args.input)

    fm = floatMatrix.FloatMatrix()
    fm.read(handle)
    
    col_filter = None
    row_filter = None
    
    if args.col_filter:
        col_filter = args.col_filter
    if args.col_filter_file:
        handle = open(args.col_filter_file)
        col_filter = handle.read()
        handle.close()

    if args.row_filter:
        row_filter = args.row_filter
    if args.row_filter_file:
        handle = open(args.row_filter_file)
        row_filter = handle.read()
        handle.close()

        
    if col_filter:
        cols = []
        for c in fm.get_cols():
            v = fm.get_col(c)
            if value_eval(col_filter, v.values(), c, fm.get_cols()):
                cols.append(c)
    else:
        cols = fm.get_cols()

    if row_filter:
        rows = []
        for c in fm.get_rows():
            v = fm.get_row(c)
            if value_eval(row_filter, v.values(), c, fm.get_rows()):
                rows.append(c)
    else:
        rows = fm.get_rows()

    ohandle = sys.stdout
    if args.output is not None:
        ohandle = open(args.output, "w")

    fm.write(ohandle, row_select=rows, col_select=cols)
    ohandle.close()






   

