#!/usr/bin/env python

import sys
import floatMatrix
import math

def matrix2zscore(matrix):    
    v = matrix.values()
    ave = sum(v) / float(len(v))
    std = math.sqrt( sum(map( lambda x: (x - ave)**2, v)) / float(len(v)) )
    out = floatMatrix.FloatMatrix()
    out.init_blank(rows=matrix.get_rows(), cols=matrix.get_cols())
    for row in matrix.get_rows():
        for col in matrix.get_cols():
            value = (matrix.get_value(row_name=row, col_name=col) - ave) / std
            out.set_value(row_name=row, col_name=col, value=value)
    return out


if __name__ == "__main__":
    path = sys.argv[1]
    if path == "-":
        handle = sys.stdin
    else:
        handle = open(matrix_path)
    
    matrix = floatMatrix.FloatMatrix()
    matrix.read(handle)
    handle.close()
    
    out = matrix2zscore(matrix)
    out.write(sys.stdout)