#!/usr/bin/env python

import sys
import csv
from optparse import OptionParser

if __name__ == "__main__":
	parser = OptionParser()
	parser.add_option("-m", "--missing", dest="missing", help="Missing", default='')
	opts, args = parser.parse_args()

	pivot_col = args[0]
	rep_cols = args[1:]

	reader = csv.reader(sys.stdin, delimiter="\t")
	writer = csv.writer(sys.stdout, delimiter="\t", lineterminator="\n")

	missing = 'Normal'

	##Read in the matrix
	header = None
	cols = []
	rows = []
	col_pos = {}
	for row in reader:
		if header is None:
			header = {}
			for i,c in enumerate(row):
				header[i] = c
				cols.append(c)
				col_pos[c] = i
		else:		
			nrow = {}
			for i,c in enumerate(cols):
				nrow[c] = row[i]
			rows.append(nrow)

	##determine all values in the pivot column
	pivot_vals = {}
	for r in rows:
		if len(r[cols[col_pos[pivot_col]]]):
			pivot_vals[ r[cols[col_pos[pivot_col]]] ] = True

	o_cols = [0]
	o_names = [header[0]]
	o_pivot = [None]
	for p in pivot_vals:
		for rc in rep_cols:
			o_pivot.append(p)
			if rc in col_pos:
				o_cols.append(cols[col_pos[rc]])
				o_names.append(p + ":" + rc)
	writer.writerow(o_names)

	ids = {}
	for r in rows:
		ids[r[cols[0]]] = True

	for i in ids:
		out_row = [opts.missing] * len(o_cols)
		out_row[0] = i
		for r in rows:
			if r[cols[0]] == i:
				for c in range(1, len(o_cols)):
					if r[pivot_col] == o_pivot[c]:
						out_row[c] = r[o_cols[c]]
		#print out_row	
		writer.writerow(out_row)
		

	
