import sys,os
import logging
import galaxy.datatypes.data
from galaxy.datatypes.data import Text
from galaxy.datatypes.metadata import MetadataElement

class ShearSvIndex( Text ):
    MetadataElement( name="base_name", desc="base name for this index set", default='shear_ref', set_in_upload=True, readonly=True )
    """
    generated files:
      copy fasta:
        base_name.fa
      index fasta with samtools index:
        base_name.fa.fai
      create 2bit with faToTwoBit:
        base_name.2bit
      create bwa index:
        base_name.fa.amb
        base_name.fa.ann
        base_name.fa.bwt
        base_name.fa.pac
        base_name.fa.rbwt
        base_name.fa.rpac
        base_name.fa.rsa
        base_name.fa.sa
    """
    file_ext = 'shear.svidx'
    composite_type = 'auto_primary_file'
    allow_datatype_change = False

    def __init__(self, **kwd):
        """Initialize  datatype"""
        Text.__init__( self, **kwd )

    def init_meta( self, dataset, copy_from=None ):
        Text.init_meta( self, dataset, copy_from=copy_from )

    def generate_primary_file( self, dataset = None ):
        """ 
        This is called only at upload to write the html file
        cannot rename the datasets here - they come with the default unfortunately
        """

    def regenerate_primary_file(self,dataset):
        """
        cannot do this until we are setting metadata 
        """
        bn = dataset.metadata.base_name
        f = file(dataset.file_name,'w')
        f.write(bn)
        f.close()

    def set_meta( self, dataset, overwrite = True, **kwd ):
        efp = dataset.extra_files_path
        flist = os.listdir(efp)
        for i,fname in enumerate(flist):
            if fname.endswith('.fa'):
                dataset.metadata.base_name = fname[:-3]
                break
            if fname.endswith('.2bit'):
                dataset.metadata.base_name = fname[:-5]
                break
        self.regenerate_primary_file(dataset)


