/*
 * Decompiled with CFR 0.152.
 */
package st_kinamine;

import java.util.HashMap;
import java.util.Map;
import st_kinamine.AminoAcid;
import st_kinamine.Run;

public class Protein {
    String seq;
    Map<Character, Double> comp = new HashMap<Character, Double>();
    Map<String, Double> props = new HashMap<String, Double>();
    int numSerThr;
    int phosphoSerThr;

    public Protein(String[] protein) {
        this.seq = protein[2];
        this.phosphoSerThr = 0;
        this.initFreq();
        this.calcFreq();
        this.calcProps();
    }

    private void initFreq() {
        for (char acid : AminoAcid.ACIDS) {
            this.comp.put(Character.valueOf(acid), 0.0);
        }
    }

    private void calcFreq() {
        for (char acid : this.seq.toCharArray()) {
            this.comp.computeIfPresent(Character.valueOf(acid), (k, v) -> v + 1.0);
        }
        this.numSerThr = this.comp.get(Character.valueOf('S')).intValue() + this.comp.get(Character.valueOf('T')).intValue();
        for (char acid : AminoAcid.ACIDS) {
            this.comp.computeIfPresent(Character.valueOf(acid), (k, v) -> v / (double)this.seq.length() * 100.0);
        }
    }

    private void calcProps() {
        for (String prop : AminoAcid.PROPS) {
            double value = 0.0;
            for (char acid : AminoAcid.ACIDS) {
                if (!Run.ACIDS.aAcids.get(Character.valueOf(acid)).contains(prop)) continue;
                value += this.comp.get(Character.valueOf(acid)).doubleValue();
            }
            this.props.put(prop, value);
        }
    }
}

