/*
 * Decompiled with CFR 0.152.
 */
package st_kinamine;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import st_kinamine.AminoAcid;
import st_kinamine.Motif;
import st_kinamine.Protein;
import st_kinamine.Run;

public class Reporter {
    static void writeReports(Run run, String outPath, String outGroup) {
        File outDir = new File(outPath);
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        System.out.print(outDir.getAbsolutePath());
        File outputFileSub = new File(outDir, outGroup + "_Substrates.csv");
        Reporter.substrates(run, outputFileSub.getPath());
        File outputFileFreq = new File(outDir, outGroup + "_SubBackFreq.csv");
        Reporter.frequencies(run, outputFileFreq.getPath());
    }

    private static void substrates(Run run, String outputFileName) {
        String header = "Substrates,Species,Reference,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,PhosphiteA,B,C,D,E,F,G,H,I,J\n";
        String detail = null;
        try (FileWriter writer = new FileWriter(outputFileName);){
            writer.append(header);
            Collection<Motif> motifs = run.motifs.values();
            for (Motif motif : motifs) {
                int j;
                int i;
                detail = ",," + motif.ref + ",";
                String seq = motif.seq;
                int index = motif.index;
                if (index < 8) {
                    for (i = index; i < 8; ++i) {
                        detail = detail + ",";
                    }
                    for (j = 0; j < seq.length(); ++j) {
                        detail = detail + seq.charAt(j) + ",";
                    }
                    if (seq.length() - index < 7) {
                        for (i = seq.length() - index; i < 7; ++i) {
                            detail = detail + ",";
                        }
                    }
                } else if (seq.length() < 15) {
                    for (j = 0; j < seq.length(); ++j) {
                        detail = detail + seq.charAt(j) + ",";
                    }
                    for (i = seq.length(); i < 15; ++i) {
                        detail = detail + ",";
                    }
                } else {
                    for (j = 0; j < seq.length(); ++j) {
                        detail = detail + seq.charAt(j) + ",";
                    }
                }
                detail = detail + ",,," + seq + ",";
                for (String id : motif.regenSeqs) {
                    detail = detail + id + ",";
                }
                detail = detail + "\n";
                writer.append(detail);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void frequencies(Run run, String outputFileName) {
        Object[] prots;
        StringBuffer header = new StringBuffer();
        header.append("Amino Acids");
        for (Object object : prots = run.database.keySet().toArray()) {
            header.append(",").append(object);
        }
        header.append("\n");
        try (FileWriter writer = new FileWriter(outputFileName);){
            writer.append(header);
            Collection<Protein> proteins = run.database.values();
            for (char acid : AminoAcid.ACIDS) {
                StringBuffer detail = new StringBuffer();
                detail.append(acid);
                for (Protein protein : proteins) {
                    detail.append(",").append(protein.comp.get(Character.valueOf(acid)));
                }
                detail.append("\n");
                writer.append(detail);
            }
            writer.append("Properties\n");
            for (String prop : AminoAcid.PROPS) {
                StringBuffer props = new StringBuffer();
                props.append(prop);
                for (Protein protein : proteins) {
                    props.append(",").append(protein.props.get(prop));
                }
                props.append("\n");
                writer.append(props);
            }
            writer.append("X\n");
            StringBuffer stringBuffer = new StringBuffer("Number of ST");
            StringBuffer phosphSerThr = new StringBuffer("Number of pST");
            StringBuffer aa = new StringBuffer("Total AAs");
            for (Protein protein : proteins) {
                stringBuffer.append(",").append(protein.numSerThr);
                phosphSerThr.append(",").append(protein.phosphoSerThr);
                aa.append(",").append(protein.seq.length());
            }
            writer.append(stringBuffer + "\n");
            writer.append(phosphSerThr + "\n");
            writer.append(aa + "\n");
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

