/*
 * Decompiled with CFR 0.152.
 */
package kinamine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kinamine.AminoAcid;
import kinamine.Motif;
import kinamine.Peptide;
import kinamine.Protein;

public final class Run {
    public final ArrayList<Peptide> pepList = new ArrayList();
    public final Map<String, Protein> database = new HashMap<String, Protein>();
    public final Map<String, Motif> motifs = new HashMap<String, Motif>();
    public static final AminoAcid ACIDS = new AminoAcid();

    public Run(ArrayList<String> peps, ArrayList<String> prots, double score) {
        this.extractPeptides(peps, score);
        this.extractDatabase(prots);
        this.generateMotifs();
    }

    private void extractPeptides(ArrayList<String> lines, double score) {
        for (String line : lines) {
            String[] pepInfo = line.split("\\t");
            if (!(Double.valueOf(pepInfo[7]) > score & !"".equals(pepInfo[3]) & pepInfo[9].contains("Phospho(Y)"))) continue;
            List<String> temp = Arrays.asList(pepInfo[3].split(";"));
            ArrayList ids = new ArrayList();
            temp.stream().forEach(id -> ids.add(id.trim()));
            for (String ref : ids) {
                if (!(!ref.contains("RRRRR") & !this.database.containsKey(ref.trim()))) continue;
                this.database.put(ref, null);
            }
            Peptide peptide = new Peptide(pepInfo, ids);
            this.pepList.add(peptide);
        }
    }

    private void extractDatabase(ArrayList<String> fastaDatabase) {
        Set<String> protList = this.database.keySet();
        for (String line : fastaDatabase) {
            String[] protInfo = line.split("\\t");
            for (String name : protList) {
                if (!protInfo[0].contains(name)) continue;
                this.database.replace(name, new Protein(protInfo));
            }
        }
    }

    private void generateMotifs() {
        for (Peptide peptide : this.pepList) {
            if (!this.hasProtID(peptide)) continue;
            for (int index : peptide.tyrIndex) {
                this.genSeq(peptide, index);
            }
        }
    }

    private void markMod(List<String> id) {
        for (String ref : id) {
            if (!this.database.containsKey(ref)) continue;
            ++this.database.get((Object)ref).phosphoTyr;
        }
    }

    private void genSeq(Peptide peptide, int index) {
        String seq;
        String motif = "";
        if (index - 7 >= 1 & index + 7 <= (seq = peptide.seq).length()) {
            motif = seq.substring(index - 8, index + 7);
            index = 8;
        } else if (index - 7 < 1 & index + 7 <= seq.length()) {
            motif = seq.substring(0, index + 7);
        } else if (index - 7 >= 1 & index + 7 > seq.length()) {
            motif = seq.substring(index - 8, seq.length());
            index = 8;
        } else {
            motif = seq;
        }
        this.addMotif(motif, peptide, index);
    }

    public boolean hasProtID(Peptide peptide) {
        return !peptide.id.isEmpty();
    }

    private void addMotif(String seq, Peptide peptide, int index) {
        if (!this.motifs.containsKey(seq)) {
            ArrayList<String> regenSeqs = this.regenSeq(peptide.id, seq, index);
            this.motifs.put(seq, new Motif(seq, peptide.ref, index, regenSeqs));
            this.markMod(peptide.id);
        } else {
            List<String> refs = peptide.id;
            List<String> ids = this.parseRef(this.motifs.get((Object)seq).ref);
            ArrayList<String> newID = new ArrayList<String>();
            for (String string : refs) {
                if (ids.contains(string)) continue;
                newID.add(string);
            }
            if (!newID.isEmpty()) {
                this.markMod(newID);
                ids.addAll(newID);
                String temp = "";
                for (String id : ids) {
                    temp = temp + id + ";";
                }
                ArrayList<String> arrayList = this.regenSeq(ids, seq, index);
                this.motifs.put(seq, new Motif(seq, temp, index, arrayList));
            }
        }
    }

    public List<String> parseRef(String ref) {
        List<String> temp = Arrays.asList(ref.split(";"));
        ArrayList<String> ids = new ArrayList<String>();
        temp.stream().forEach(id -> ids.add(id.trim()));
        return ids;
    }

    private ArrayList<String> regenSeq(List<String> ids, String seq, int i) {
        ArrayList<String> seqs = new ArrayList<String>();
        for (String id : ids) {
            if (!this.database.containsKey(id)) continue;
            String prot = this.database.get((Object)id).seq;
            int index = prot.indexOf(seq) + i;
            String motif = "";
            motif = index - 7 >= 1 & index + 7 <= prot.length() ? prot.substring(index - 8, index + 7) : (index - 7 < 1 & index + 7 <= prot.length() ? prot.substring(0, index + 7) : (index - 7 >= 1 & index + 7 > prot.length() ? prot.substring(index - 8, prot.length()) : prot));
            if (seqs.contains(motif)) continue;
            seqs.add(motif);
        }
        return seqs;
    }
}

