/*
 * Decompiled with CFR 0.152.
 */
package kinamine;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import kinamine.AminoAcid;
import kinamine.Motif;
import kinamine.Protein;
import kinamine.Run;

public class Reporter {
    static void writeReports(Run run, String outPath, String outGroup) {
        String outputFileSub = outPath + outGroup + "_Substrates.csv";
        Reporter.substrates(run, outputFileSub);
        String outputFileFreq = outPath + outGroup + "_SubBackFreq.csv";
        Reporter.frequencies(run, outputFileFreq);
    }

    private static void substrates(Run run, String outputFileName) {
        String header = "Substrates,Species,Reference,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7, , , ,Phosphite\n";
        String detail = null;
        try (FileWriter writer = new FileWriter(outputFileName);){
            writer.append(header);
            Collection<Motif> motifs = run.motifs.values();
            for (Motif motif : motifs) {
                int j;
                int i;
                detail = ",," + motif.ref + ",";
                String seq = motif.seq;
                int index = motif.index;
                if (index < 8) {
                    for (i = index; i < 8; ++i) {
                        detail = detail + ",";
                    }
                    for (j = 0; j < seq.length(); ++j) {
                        detail = detail + seq.charAt(j) + ",";
                    }
                    if (seq.length() - index < 7) {
                        for (i = seq.length() - index; i < 7; ++i) {
                            detail = detail + ",";
                        }
                    }
                } else if (seq.length() < 15) {
                    for (j = 0; j < seq.length(); ++j) {
                        detail = detail + seq.charAt(j) + ",";
                    }
                    for (i = seq.length(); i < 15; ++i) {
                        detail = detail + ",";
                    }
                } else {
                    for (j = 0; j < seq.length(); ++j) {
                        detail = detail + seq.charAt(j) + ",";
                    }
                }
                detail = detail + ",,," + seq + ",";
                for (String id : motif.regenSeqs) {
                    detail = detail + id + ",";
                }
                detail = detail + "\n";
                writer.append(detail);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void frequencies(Run run, String outputFileName) {
        Object[] prots;
        StringBuffer header = new StringBuffer();
        header.append("Amino Acids,");
        for (Object object : prots = run.database.keySet().toArray()) {
            header.append(object).append(",");
        }
        header.append("\n");
        try (FileWriter writer = new FileWriter(outputFileName);){
            writer.append(header);
            Collection<Protein> proteins = run.database.values();
            for (char acid : AminoAcid.ACIDS) {
                StringBuffer detail = new StringBuffer();
                detail.append(acid).append(",");
                for (Protein protein : proteins) {
                    detail.append(protein.comp.get(Character.valueOf(acid))).append(",");
                }
                detail.append("\n");
                writer.append(detail);
            }
            writer.append("Properties\n");
            for (String prop : AminoAcid.PROPS) {
                StringBuffer props = new StringBuffer();
                props.append(prop).append(",");
                for (Protein protein : proteins) {
                    props.append(protein.props.get(prop)).append(",");
                }
                props.append("\n");
                writer.append(props);
            }
            writer.append("\n");
            StringBuffer stringBuffer = new StringBuffer("Number of Y,");
            StringBuffer phosphTyr = new StringBuffer("Number of pY,");
            StringBuffer aa = new StringBuffer("Total AAs,");
            for (Protein protein : proteins) {
                stringBuffer.append(protein.numTyr).append(",");
                phosphTyr.append(protein.phosphoTyr).append(",");
                aa.append(protein.seq.length()).append(",");
            }
            writer.append(stringBuffer + "\n");
            writer.append(phosphTyr + "\n");
            writer.append(aa + "\n");
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

