/*
 * Decompiled with CFR 0.152.
 */
package kinamine;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import kinamine.KinaMine;
import kinamine.KinaMineDriver;

public class KinaMineGUIController
implements Initializable {
    @FXML
    private TextField pepPath;
    @FXML
    private TextField fastaPath;
    @FXML
    private TextField outPath;
    @FXML
    private TextField fdrScore;
    @FXML
    private TextField outGroup;
    private boolean debug;
    @FXML
    File lastDirectory;

    @FXML
    public void pepSearchClicked(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Tabular", new String[]{"*.tabular", "*.txt"});
        KinaMineGUIController.configFileChooser(fileChooser, this.lastDirectory, filter);
        File selectedFile = fileChooser.showOpenDialog((Window)KinaMine.stage);
        if (selectedFile != null) {
            this.lastDirectory = new File(selectedFile.getParent());
            this.pepPath.setText(selectedFile.getAbsolutePath());
        }
    }

    @FXML
    public void fastaSearchClicked(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Database", new String[]{"*.fasta", "*.tabular"});
        KinaMineGUIController.configFileChooser(fileChooser, this.lastDirectory, filter);
        File selectedFile = fileChooser.showOpenDialog((Window)KinaMine.stage);
        if (selectedFile != null) {
            this.lastDirectory = new File(selectedFile.getParent());
            this.fastaPath.setText(selectedFile.getAbsolutePath());
        }
    }

    private static void configFileChooser(FileChooser fileChooser, File lastDir, FileChooser.ExtensionFilter filter) {
        fileChooser.setTitle("Open File");
        fileChooser.getExtensionFilters().add((Object)filter);
        if (lastDir == null) {
            fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        } else {
            fileChooser.setInitialDirectory(lastDir);
        }
    }

    public void browseFolderClicked(ActionEvent event) {
        DirectoryChooser dirChooser = new DirectoryChooser();
        dirChooser.setTitle("Choose Output Location");
        if (this.lastDirectory != null) {
            dirChooser.setInitialDirectory(this.lastDirectory);
        } else {
            dirChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        File output = dirChooser.showDialog((Window)KinaMine.stage);
        if (output != null) {
            this.outPath.setText(output.getAbsolutePath());
        }
    }

    public void submitButtonClicked(ActionEvent event) {
        String[] args = new String[]{this.pepPath.getText(), this.fastaPath.getText(), this.outPath.getText(), this.fdrScore.getText(), this.outGroup.getText()};
        ArrayList<String> error = this.checkForErrors(args);
        if (error.isEmpty()) {
            this.debug = true;
            boolean status = KinaMineDriver.run(args, true);
            this.completeWindow();
        } else {
            this.alertError(error);
        }
    }

    public ArrayList<String> checkForErrors(String[] args) {
        ArrayList<String> error = new ArrayList<String>();
        File pep = new File(args[0]);
        File fasta = new File(args[1]);
        File dir = new File(args[2]);
        String score = args[3];
        if (!pep.isFile()) {
            error.add(args[0] + " is not a file.");
        }
        if (!pep.canRead()) {
            error.add("Can't read peptide report: " + args[0]);
        }
        if (!fasta.isFile()) {
            error.add(args[1] + " is not a file.");
        }
        if (!fasta.canRead()) {
            error.add("Can't read database: " + args[0]);
        }
        if (!dir.isDirectory()) {
            error.add(dir + " is not a directory.");
        }
        if (!score.matches("[-+]?\\d*\\.?\\d+")) {
            error.add("FDR Score: " + score + " is not a number.");
        }
        return error;
    }

    public void alertError(ArrayList<String> errors) {
        Stage window = new Stage();
        window.initModality(Modality.APPLICATION_MODAL);
        window.setTitle("Error");
        window.setMinWidth(250.0);
        String message = "";
        for (String error : errors) {
            message = message + error + "\n";
        }
        Label label = new Label(message);
        Button closeButton = new Button("Close\n");
        closeButton.setOnAction(e -> window.close());
        VBox layout = new VBox(10.0);
        layout.getChildren().addAll((Object[])new Node[]{label, closeButton});
        layout.setAlignment(Pos.CENTER);
        Scene scene = new Scene((Parent)layout);
        window.setScene(scene);
        window.showAndWait();
    }

    public void completeWindow() {
        Stage window = new Stage();
        window.initModality(Modality.APPLICATION_MODAL);
        window.setMinWidth(250.0);
        Label label = new Label("Run Complete");
        Button closeButton = new Button("Done");
        closeButton.setOnAction(e -> window.close());
        VBox layout = new VBox(10.0);
        layout.getChildren().addAll((Object[])new Node[]{label, closeButton});
        layout.setAlignment(Pos.CENTER);
        Scene scene = new Scene((Parent)layout);
        window.setScene(scene);
        window.showAndWait();
    }

    public void initialize(URL url, ResourceBundle rb) {
        System.out.println("Initializing...");
        this.lastDirectory = null;
        assert (this.pepPath != null) : "fx:id=\"pepPath\" was not injected: check your FXML file 'KinaMineGUI.fxml'.";
        assert (this.fastaPath != null) : "fx:id=\"fastaPath\" was not injected: check your FXML file 'KinaMineGUI.fxml'.";
        assert (this.outPath != null) : "fx:id=\"outPath\" was not injected: check your FXML file 'KinaMineGUI.fxml'.";
    }
}

