/*
 * Decompiled with CFR 0.152.
 */
package kinamine;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import kinamine.Reporter;
import kinamine.Run;

public class KinaMineDriver {
    public static boolean run(String[] args, boolean debug) {
        String pepPath = args[0];
        String fastaPath = args[1];
        String outPath = args[2];
        double fdrScore = Double.valueOf(args[3]);
        String outGroup = "output";
        ArrayList<String> peptides = KinaMineDriver.retTabFile(pepPath);
        peptides.remove(0);
        ArrayList<String> proteins = new ArrayList();
        proteins = fastaPath.contains("fasta") ? KinaMineDriver.retFastaFile(fastaPath) : KinaMineDriver.retTabFile(fastaPath);
        Run run = new Run(peptides, proteins, fdrScore);
        Reporter.writeReports(run, outPath, outGroup);
        return true;
    }

    public static ArrayList<String> retTabFile(String path) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            FileReader fr = new FileReader(path);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            while (line != null && !line.startsWith("\t")) {
                lines.add(line);
                line = br.readLine();
            }
            br.close();
        }
        catch (FileNotFoundException filenotfoundexxption) {
            System.out.println(path + ", does not exist");
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
        return lines;
    }

    public static ArrayList<String> retFastaFile(String path) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            FileReader fr = new FileReader(path);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            String prot = "";
            while (line != null) {
                if (line.startsWith(">")) {
                    String[] temp = line.split(" ");
                    prot = temp[0].trim() + "\t \t";
                } else {
                    prot = prot + line.trim();
                    lines.add(prot);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (FileNotFoundException filenotfoundexxption) {
            System.out.println(path + ", does not exist");
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
        return lines;
    }
}

