/*
 * Decompiled with CFR 0.152.
 */
package kinamine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AminoAcid {
    public final Map<Character, ArrayList<String>> aAcids = new HashMap<Character, ArrayList<String>>();
    public static final String[] PROPS = new String[]{"Hydrophobic", "Polar", "Small", "Negative", "Postive", "Amide", "Large Aliphatic", "Small Aliphatic", "Aromatic", "Hydroxy"};
    public static final char[] ACIDS = new char[]{'A', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'Y'};

    public AminoAcid() {
        this.initAcids();
        this.initProps();
    }

    private void initAcids() {
        for (char acid : ACIDS) {
            this.aAcids.put(Character.valueOf(acid), new ArrayList());
        }
    }

    private void initProps() {
        this.aAcids.get(Character.valueOf('A')).addAll(this.getProps(0, 2, 7));
        this.aAcids.get(Character.valueOf('C')).addAll(this.getProps(0, 2));
        this.aAcids.get(Character.valueOf('D')).addAll(this.getProps(1, 2, 3));
        this.aAcids.get(Character.valueOf('E')).addAll(this.getProps(1, 3));
        this.aAcids.get(Character.valueOf('F')).addAll(this.getProps(0, 8));
        this.aAcids.get(Character.valueOf('G')).addAll(this.getProps(0, 2, 7));
        this.aAcids.get(Character.valueOf('H')).addAll(this.getProps(1, 4));
        this.aAcids.get(Character.valueOf('I')).addAll(this.getProps(0, 6));
        this.aAcids.get(Character.valueOf('K')).addAll(this.getProps(1, 4));
        this.aAcids.get(Character.valueOf('L')).addAll(this.getProps(0, 6));
        this.aAcids.get(Character.valueOf('M')).addAll(this.getProps(0));
        this.aAcids.get(Character.valueOf('N')).addAll(this.getProps(1, 2, 5));
        this.aAcids.get(Character.valueOf('P')).addAll(this.getProps(2));
        this.aAcids.get(Character.valueOf('Q')).addAll(this.getProps(1, 5));
        this.aAcids.get(Character.valueOf('R')).addAll(this.getProps(1, 4));
        this.aAcids.get(Character.valueOf('S')).addAll(this.getProps(2, 9));
        this.aAcids.get(Character.valueOf('T')).addAll(this.getProps(2, 9));
        this.aAcids.get(Character.valueOf('V')).addAll(this.getProps(0, 2, 7));
        this.aAcids.get(Character.valueOf('W')).addAll(this.getProps(0, 8));
        this.aAcids.get(Character.valueOf('Y')).addAll(this.getProps(0, 8));
    }

    private ArrayList<String> getProps(int ... ints) {
        ArrayList<String> props = new ArrayList<String>();
        for (int index : ints) {
            props.add(PROPS[index]);
        }
        return props;
    }
}

