/*
 * Decompiled with CFR 0.152.
 */
package mda.ngchm.datagenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class RowColData {
    public String orderType = null;
    public String orderFile = null;
    public String orderMethod = null;
    public String distanceMetric = null;
    public String agglomerationMethod = null;
    public String dendroFile = null;
    public int[] orderArray;

    public RowColData(String type, int length, String fileO, String method, String distance, String agglomeration, String fileD) {
        this.orderType = type.trim();
        this.orderFile = fileO.trim();
        this.orderMethod = method.trim();
        this.distanceMetric = distance.trim();
        this.agglomerationMethod = agglomeration.trim();
        this.dendroFile = fileD.trim();
        this.orderArray = new int[length + 1];
        this.setClassificationOrder(new File(this.orderFile), this.orderArray);
    }

    public RowColData(String type, int length, String file, String method) {
        this.orderType = type.trim();
        this.orderFile = file.trim();
        this.orderMethod = method.trim();
        this.orderArray = new int[length + 1];
        this.setClassificationOrder(new File(this.orderFile), this.orderArray);
    }

    private void setClassificationOrder(File filename, int[] orderArray) {
        try {
            filename.exists();
            BufferedReader rowRead = new BufferedReader(new FileReader(filename));
            String line = rowRead.readLine();
            line = rowRead.readLine();
            int pos = 1;
            while (line != null) {
                String[] toks = line.split("\t");
                orderArray[pos] = Integer.parseInt(toks[1]);
                ++pos;
                line = rowRead.readLine();
            }
            rowRead.close();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

