/*
 * Decompiled with CFR 0.152.
 */
package mda.ngchm.datagenerator;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import mda.ngchm.datagenerator.ColorMap;

public class ColorMapGenerator {
    public static final String[] defaultColors = new String[]{"#1f77b4", "#aec7e8", "#ff7f0e", "#ffbb78", "#2ca02c", "#98df8a", "#d62728", "#ff9896", "#9467bd", "#c5b0d5", "#8c564b", "#c49c94", "#e377c2", "#f7b6d2", "#7f7f7f", "#c7c7c7", "#bcbd22", "#dbdb8d", "#17becf", "#9edae5"};
    public static final String[] blueWhiteRed = new String[]{"#0000FF", "#FFFFFF", "#FF0000"};

    public static ColorMap getDefaultColors(String ifile, ColorMap cm) {
        if (!(cm.type.equals("linear") || cm.type.equals("quantile") || cm.type.equals("discrete") || cm.type.equals("continuous"))) {
            return null;
        }
        cm.missingColor = Color.black;
        if (ColorMapGenerator.colorsSupplied(ifile)) {
            ColorMapGenerator.getColorSchemeCont(ifile, cm);
        } else if (cm.type.equals("linear")) {
            ArrayList<Double> range = ColorMapGenerator.getDataRange(ifile);
            cm.breaks.add(range.get(0).toString());
            cm.breaks.add(range.get(1).toString());
            cm.breaks.add(range.get(2).toString());
            cm.colors.add(Color.blue);
            cm.colors.add(Color.white);
            cm.colors.add(Color.red);
        } else if (cm.type.equals("quantile")) {
            cm.breaks.add("0.25");
            cm.breaks.add("0.50");
            cm.breaks.add("0.75");
            cm.colors.add(Color.blue);
            cm.colors.add(Color.white);
            cm.colors.add(Color.red);
        } else if (cm.type.equals("continuous")) {
            ArrayList<Double> range = ColorMapGenerator.getMinMax(ifile);
            cm.breaks.add(range.get(0).toString());
            cm.breaks.add(range.get(2).toString());
            cm.colors.add(Color.white);
            cm.colors.add(Color.red);
        } else if (cm.type.equals("discrete")) {
            ArrayList<String> categories = ColorMapGenerator.getCategories(ifile);
            int i = 0;
            for (String cat : categories) {
                cm.breaks.add(cat);
                if (i < defaultColors.length - 1) {
                    cm.colors.add(Color.decode(defaultColors[i]));
                } else {
                    cm.colors.add(Color.decode(defaultColors[defaultColors.length - 1]));
                }
                ++i;
            }
        }
        return cm;
    }

    private static ArrayList<Double> getMinMax(String classificationFile) {
        Double min = Double.MAX_VALUE;
        Double mid = 0.0;
        Double max = Double.MIN_VALUE;
        try {
            BufferedReader read = new BufferedReader(new FileReader(new File(classificationFile)));
            String line = read.readLine();
            while (line != null) {
                String[] toks = (line = line.trim()).split("\t");
                if (toks.length > 1) {
                    Double value = null;
                    try {
                        value = Double.parseDouble(toks[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (value != null && value < min) {
                        min = value;
                    }
                    if (value != null && value > max) {
                        max = value;
                    }
                }
                line = read.readLine();
            }
            read.close();
            mid = (min + max) / 2.0;
        }
        catch (Exception e) {
            System.out.println("Error reading classification bar file ");
            e.printStackTrace();
        }
        ArrayList<Double> result = new ArrayList<Double>();
        result.add(min);
        result.add(mid);
        result.add(max);
        return result;
    }

    private static ArrayList<Double> getDataRange(String dataFile) {
        Double min = Double.MAX_VALUE;
        Double mid = 0.0;
        Double max = Double.MIN_VALUE;
        try {
            BufferedReader read = new BufferedReader(new FileReader(new File(dataFile)));
            String line = read.readLine();
            line = read.readLine();
            while (line != null) {
                line = line.trim();
                String[] toks = line.split("\t");
                int i = 1;
                while (i < toks.length) {
                    Double value = null;
                    try {
                        value = Double.parseDouble(toks[i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (value != null && value < min) {
                        min = value;
                    }
                    if (value != null && value > max) {
                        max = value;
                    }
                    ++i;
                }
                line = read.readLine();
            }
            read.close();
            mid = min < 0.0 && max > 0.0 ? Double.valueOf(0.0) : Double.valueOf((min + max) / 2.0);
        }
        catch (Exception e) {
            System.out.println("Error reading classification bar file ");
            e.printStackTrace();
        }
        ArrayList<Double> result = new ArrayList<Double>();
        result.add(min);
        result.add(mid);
        result.add(max);
        return result;
    }

    private static ArrayList<String> getCategories(String classificationFileWFullPath) {
        ArrayList<String> cats = new ArrayList<String>();
        try {
            BufferedReader read = new BufferedReader(new FileReader(new File(classificationFileWFullPath)));
            String line = read.readLine();
            while (line != null) {
                String[] toks = (line = line.trim()).split("\t");
                if (!(toks.length <= 1 || cats.contains(toks[1]) || toks[1].equalsIgnoreCase("None") || toks[1].equalsIgnoreCase("NA") || toks[1].equalsIgnoreCase("NA"))) {
                    cats.add(toks[1]);
                }
                line = read.readLine();
            }
            read.close();
        }
        catch (Exception e) {
            System.out.println("Error reading classification bar file ");
            e.printStackTrace();
        }
        return cats;
    }

    private static boolean colorsSupplied(String classificationFile) {
        boolean supplied = false;
        try {
            BufferedReader read = new BufferedReader(new FileReader(new File(classificationFile)));
            String line = read.readLine().toLowerCase();
            int i = 0;
            while (line != null && i < 10) {
                if ((line = line.trim()).contains("<color-scheme>")) {
                    supplied = true;
                    break;
                }
                line = read.readLine().toLowerCase();
                ++i;
            }
            read.close();
        }
        catch (Exception e) {
            System.out.println("Error reading classification bar file ");
            e.printStackTrace();
        }
        return supplied;
    }

    private static void getColorSchemeCont(String classColorDefFile, ColorMap cm) {
        boolean startRead = false;
        try {
            BufferedReader read = new BufferedReader(new FileReader(new File(classColorDefFile)));
            String line = read.readLine();
            int i = 0;
            while (i < 50) {
                line = line.trim();
                if (!startRead) {
                    if (line.toLowerCase().contains("<color-scheme>")) {
                        startRead = true;
                    }
                } else {
                    if (line.toLowerCase().contains("</color-scheme>")) break;
                    String[] toks = line.split("\t");
                    cm.breaks.add(toks[0]);
                    cm.colors.add(Color.decode(toks[1]));
                }
                line = read.readLine();
                ++i;
            }
            read.close();
        }
        catch (Exception e) {
            System.out.println("Error reading classification color bar file ");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ColorMap cm = new ColorMap();
        ColorMapGenerator.getDefaultColors("C:\\NGCHMProto\\400x400\\400x400.txt", cm);
        System.out.println(cm.asJSON());
    }
}

