/*
 * Decompiled with CFR 0.152.
 */
package mda.ngchm.datagenerator;

import java.awt.Color;
import java.util.ArrayList;
import mda.ngchm.datagenerator.HeatmapDataGenerator;
import mda.ngchm.datagenerator.ImportConstants;

public class ColorMap {
    public String id;
    public String type;
    public ArrayList<Color> colors = new ArrayList();
    public Color missingColor;
    public ArrayList<String> breaks = new ArrayList();

    public String asJSON() {
        StringBuffer json = new StringBuffer(String.valueOf(ImportConstants.QUOTE) + this.id + ImportConstants.QUOTE + ImportConstants.COLON + ImportConstants.BRACE_OPEN);
        json.append(String.valueOf(ImportConstants.TYPE_LABEL) + ImportConstants.QUOTE + this.type + ImportConstants.QUOTE + ImportConstants.COMMA);
        json.append(String.valueOf(ImportConstants.COLORS_LABEL) + ImportConstants.BRACKET_OPEN + ImportConstants.QUOTE + ImportConstants.HASHTAG + this.toHex(this.colors.get(0)) + ImportConstants.QUOTE);
        int i = 1;
        while (i < this.colors.size()) {
            json.append(String.valueOf(ImportConstants.COMMA) + ImportConstants.QUOTE + ImportConstants.HASHTAG + this.toHex(this.colors.get(i)) + ImportConstants.QUOTE);
            ++i;
        }
        json.append(String.valueOf(ImportConstants.BRACKET_CLOSE) + ImportConstants.COMMA);
        boolean isNumeric = this.areBreaksNumeric(this.breaks);
        json.append(String.valueOf(ImportConstants.THRESHOLDS_LABEL) + ImportConstants.BRACKET_OPEN + this.getBreakString(this.breaks.get(0), isNumeric));
        int i2 = 1;
        while (i2 < this.breaks.size()) {
            json.append(String.valueOf(ImportConstants.COMMA) + this.getBreakString(this.breaks.get(i2), isNumeric));
            ++i2;
        }
        json.append(String.valueOf(ImportConstants.BRACKET_CLOSE) + ImportConstants.COMMA);
        json.append(String.valueOf(ImportConstants.MISSING_LABEL) + ImportConstants.QUOTE + ImportConstants.HASHTAG + this.toHex(this.missingColor) + ImportConstants.QUOTE);
        json.append(ImportConstants.BRACE_CLOSE);
        return json.toString();
    }

    private String getBreakString(String breakpt, boolean isNumeric) {
        if (!isNumeric) {
            breakpt = String.valueOf(ImportConstants.QUOTE) + breakpt + ImportConstants.QUOTE;
        }
        return breakpt;
    }

    private boolean areBreaksNumeric(ArrayList<String> breaks) {
        boolean isNumeric = true;
        int i = 0;
        while (i < breaks.size()) {
            if (!HeatmapDataGenerator.isNumeric(breaks.get(i))) {
                isNumeric = false;
            }
            ++i;
        }
        return isNumeric;
    }

    private String toHex(Color c) {
        String hex = Integer.toHexString(c.getRGB());
        return hex.substring(2);
    }
}

