/*
 * Decompiled with CFR 0.152.
 */
package mda.ngchm.servlet;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@WebServlet(value={"/SaveMapProperties"})
public class SaveMapProperties
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String mapLocation = "/NGCHMProto";

    protected boolean updateColorMaps(String map, JSONObject colorMap) {
        boolean success = true;
        try {
            String colorMapFile = mapLocation + File.separator + map + File.separator + "colormaps.json";
            DataOutputStream writer = new DataOutputStream(new FileOutputStream(colorMapFile));
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)writer, "utf-8");
            fw.write(colorMap.toString());
            fw.close();
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }

    protected boolean updateClassifications(String map, JSONObject classifications) {
        boolean success = true;
        try {
            String classificationsFile = mapLocation + File.separator + map + File.separator + "classifications.json";
            DataOutputStream writer = new DataOutputStream(new FileOutputStream(classificationsFile));
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)writer, "utf-8");
            fw.write(classifications.toString());
            fw.close();
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }

    protected boolean updateDendrogram(String map, JSONObject dendrogram) {
        boolean success = true;
        try {
            String dendrogramFile = mapLocation + File.separator + map + File.separator + "dendrogram.json";
            DataOutputStream writer = new DataOutputStream(new FileOutputStream(dendrogramFile));
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)writer, "utf-8");
            fw.write(dendrogram.toString());
            fw.close();
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }

    protected Boolean processRequest(HttpServletRequest request, HttpServletResponse response) {
        String mapName = request.getParameter("map");
        String propertyType = request.getParameter("type");
        Boolean success = false;
        try {
            String line;
            StringBuilder buffer = new StringBuilder();
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            String data = buffer.toString();
            JSONParser parser = new JSONParser();
            JSONObject jsonObject = (JSONObject)parser.parse(data);
            switch (propertyType) {
                case "colorMap": {
                    success = this.updateColorMaps(mapName, jsonObject);
                    break;
                }
                case "classifications": {
                    success = this.updateClassifications(mapName, jsonObject);
                    break;
                }
                case "dendrogram": {
                    success = this.updateDendrogram(mapName, jsonObject);
                    break;
                }
                default: {
                    success = false;
                    break;
                }
            }
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/binary");
        ServletOutputStream output = response.getOutputStream();
        Boolean success = this.processRequest(request, response);
        output.write(success.toString().getBytes("UTF-8"));
        response.flushBuffer();
    }
}

