/*
 * Decompiled with CFR 0.152.
 */
package mda.ngchm.datagenerator;

import java.io.File;
import mda.ngchm.datagenerator.ImportConstants;
import mda.ngchm.datagenerator.ImportLayerData;

public class ImportTileData {
    public String fileName;
    public int rowStartPos;
    public int rowEndPos;
    public int colStartPos;
    public int colEndPos;

    public ImportTileData(ImportLayerData layerData, int tileCol, int tileRow) {
        this.fileName = String.valueOf(File.separator) + layerData.layer + File.separator + layerData.layer + "." + (tileRow + 1) + "." + (tileCol + 1) + ImportConstants.BIN_FILE;
        switch (layerData.layer) {
            case "tn": {
                this.setupThumbnailTile(layerData);
                break;
            }
            case "s": {
                this.setupSummaryTile(layerData, tileCol, tileRow);
                break;
            }
            case "d": {
                this.setupDetailTile(layerData, tileCol, tileRow);
                break;
            }
            case "rh": {
                this.setupRibbonHorizTile(layerData, tileCol, tileRow);
                break;
            }
            case "rv": {
                this.setupRibbonVertTile(layerData, tileCol, tileRow);
            }
        }
    }

    private void setupThumbnailTile(ImportLayerData layerData) {
        this.rowStartPos = 1;
        this.rowEndPos = layerData.importRows + 1;
        this.colStartPos = 1;
        this.colEndPos = layerData.importCols + 1;
    }

    private void setupSummaryTile(ImportLayerData layerData, int tileCol, int tileRow) {
        int rowStartingPos = 1;
        int rowMidPoint = layerData.rowsPerTile * layerData.rowInterval + rowStartingPos;
        if (tileRow == 0) {
            this.rowStartPos = rowStartingPos;
            this.rowEndPos = rowMidPoint;
        } else {
            this.rowStartPos = rowMidPoint;
            this.rowEndPos = layerData.importRows + 1;
        }
        int colStartingPos = 1;
        int colMidPoint = layerData.colsPerTile * layerData.colInterval + colStartingPos;
        if (tileCol == 0) {
            this.colStartPos = colStartingPos;
            this.colEndPos = colMidPoint;
        } else {
            this.colStartPos = colMidPoint;
            this.colEndPos = layerData.importCols + 1;
        }
    }

    private void setupDetailTile(ImportLayerData layerData, int tileCol, int tileRow) {
        this.rowStartPos = tileRow == 0 ? 1 : tileRow * ImportConstants.TILE_SIZE + 1;
        this.rowEndPos = ImportConstants.TILE_SIZE + this.rowStartPos;
        if (this.rowEndPos > layerData.importRows) {
            this.rowEndPos = layerData.importRows + 1;
        }
        this.colStartPos = tileCol == 0 ? 1 : tileCol * ImportConstants.TILE_SIZE + 1;
        this.colEndPos = ImportConstants.TILE_SIZE + this.colStartPos;
        if (this.colEndPos > layerData.importCols) {
            this.colEndPos = layerData.importCols + 1;
        }
    }

    private void setupRibbonVertTile(ImportLayerData layerData, int tileCol, int tileRow) {
        int rowStartingPos = 1;
        int rowMidPoint = layerData.rowsPerTile * layerData.rowInterval + rowStartingPos;
        if (tileRow == 0) {
            this.rowStartPos = rowStartingPos;
            this.rowEndPos = rowMidPoint;
        } else {
            this.rowStartPos = rowMidPoint;
            this.rowEndPos = layerData.importRows + 1;
        }
        this.colStartPos = tileCol == 0 ? 1 : tileCol * ImportConstants.TILE_SIZE + 1;
        this.colEndPos = ImportConstants.TILE_SIZE + this.colStartPos;
        if (this.colEndPos > layerData.importCols) {
            this.colEndPos = layerData.importCols + 1;
        }
    }

    private void setupRibbonHorizTile(ImportLayerData layerData, int tileCol, int tileRow) {
        if (tileRow == 0) {
            this.rowStartPos = 1;
            this.rowEndPos = ImportConstants.TILE_SIZE + this.rowStartPos;
        } else {
            this.rowStartPos = tileRow * ImportConstants.TILE_SIZE;
            this.rowEndPos = ImportConstants.TILE_SIZE + this.rowStartPos + 1;
        }
        if (this.rowEndPos > layerData.importRows) {
            this.rowEndPos = layerData.importRows + 1;
        }
        int colStartingPos = 1;
        int colMidPoint = layerData.colsPerTile * layerData.colInterval + colStartingPos;
        if (tileCol == 0) {
            this.colStartPos = colStartingPos;
            this.colEndPos = colMidPoint;
        } else {
            this.colStartPos = colMidPoint;
            this.colEndPos = layerData.importCols + 1;
        }
    }
}

